#!/usr/bin/env python

########################################################################
# Chris's Lame File Browser 4
# Copyright 2004, Gabe Ginorio <gabe@zevallos.com.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################################################

import pygtk
pygtk.require("2.0")

import gtk
import os, os.path, sys, string
language = gtk.get_default_language()
print "System Language is:",language.to_string()
sys.path.append(os.path.abspath(string.replace(os.path.abspath(sys.argv[0]), "claw4.py", "") + "Modules/"))

import create, mimetype

class Claw4:

	def __init__(self):

		# Make sure the configure directory exists
		if not os.path.exists(os.environ['HOME'] + "/.claw/"):
			os.mkdir(os.environ['HOME'] + "/.claw/")

		# Make sure the trash directory exists
		if not os.path.exists(os.environ['HOME'] + "/..Wastebasket"):
			os.mkdir(os.environ['HOME'] + "/..Wastebasket")			

		# Initilize the mimetypes
		mimetype.initialize()
		
		# Create the main window and table for formatting
		self.main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.main_window.set_title("Chris's Lame File Browser 4")
		self.main_window.connect("destroy", gtk.main_quit)
		self.main_window.resize(600, 600)
		
		icon_path = string.replace(os.path.abspath(sys.argv[0]), "claw4.py", "/Images/logo.png")
		self.main_window.set_icon_from_file(icon_path)
	
		main_table = gtk.Table()
		self.main_window.add(main_table)
	
		# Create the other widget items (toolbar, addressbar, notebook, etc.)
		create.initialize(main_table)

		# Show everything in the main window
		self.main_window.show_all()
	
	def main(self):
		gtk.main()
		
		
if __name__=="__main__":
	claw4 = Claw4()
	claw4.main()
	
