# -*- mode: sh; mode: font-lock -*-
# AM_PATH_MCCP4([ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND]]) 
AC_DEFUN([AM_PATH_MCCP4],
[
AC_PROVIDE([AM_PATH_MCCP4])

AC_ARG_WITH(mccp4,
  AC_HELP_STRING( [--with-mccp4=PFX], [use mccp4 library (default is NO) and set prefix]),
  [
    test "$withval" = no || with_mccp4=yes 
    test "$withval" = yes || mccp4_prefix="$withval" ],
  [ with_mccp4="$enable_mccp4" ] ) #dnl default is no for now

if test x$with_mccp4 = xyes ; then  

#user override
AS_IF([test "x$MCCP4_LIBS" != x && test "x$MCCP4_CXXFLAGS" != x ],
[
  have_mccp4=yes
],
[
AC_MSG_CHECKING([for ccp4_errno in MCCP4])

saved_LIBS="$LIBS"
saved_CXXFLAGS="$CXXFLAGS"
MCCP4_LIBS=""
MCCP4_CXXFLAGS=""

if test "x$mccp4_prefix" != x; then
 # ie. mccp4=thing was given (thing is what we're checking for)
 ac_MCCP4_CXXFLAGS="-I$mccp4_prefix/include/mccp4"
 ac_MCCP4_LDOPTS="-L$mccp4_prefix/lib -lmccp4"
else
 # treat as standard lib/include
 ac_MCCP4_CXXFLAGS=""
 ac_MCCP4_LDOPTS="-lmccp4"
fi

LIBS="$ac_MCCP4_LDOPTS $saved_LIBS"
CXXFLAGS="$ac_MCCP4_CXXFLAGS $saved_CXXFLAGS"
#
# AC_TRY_LINK uses the c compiler (set by AC_LANG), so we will
# temporarily reassign $CC to the c++ compiler.
#
AC_LANG_PUSH(C++)
AC_TRY_LINK([#include "ccp4_errno.h"],
  [int a = ccp4_errno; CCP4::ccp4_error("conftest"); ], have_mccp4=yes, have_mccp4=no)
AC_LANG_POP(C++)  # the language we have just quit
AC_MSG_RESULT($have_mccp4)

 LIBS="$saved_LIBS"
 CXXFLAGS="$saved_CXXFLAGS"
]) #user override

AS_IF([test x$have_mccp4 = xyes],
  [
    MCCP4_CXXFLAGS="$ac_MCCP4_CXXFLAGS"
    MCCP4_LIBS="$ac_MCCP4_LDOPTS"
    ifelse([$1], , :, [$1]) ],
  [
    ifelse([$2], , :, [$2]) ]
)

fi #dnl --with-mccp4

AC_SUBST(MCCP4_CXXFLAGS)
AC_SUBST(MCCP4_LIBS)
])
