#include <clutter/clutter.h>
#include "clutter-cairo.h"
#include "math.h"

void 
drawClock(cairo_t * cr)
{
  /* clock drawing code from http://www.cairographics.org/SDLCLock */

  /* store the current time */
  time_t rawtime;
  struct tm *timeinfo;
  double minutes, hours, seconds;

  time(&rawtime);
  
  /* In newer versions of Visual Studio localtime(..) is deprecated. */
  /* Use localtime_s instead. See MSDN. */
  timeinfo = localtime (&rawtime);

  /* compute the angles for the indicators of our clock */
  minutes = timeinfo->tm_min * M_PI / 30;
  hours = timeinfo->tm_hour * M_PI / 6;
  seconds = timeinfo->tm_sec * M_PI / 30;

  /* Clear our surface */
  cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
  cairo_paint(cr);

  cairo_set_operator (cr, CAIRO_OPERATOR_OVER);

  /* who doesn't want all those nice line settings :) */
  cairo_set_line_cap(cr, CAIRO_LINE_CAP_ROUND);
  cairo_set_line_width(cr, 0.1);

  /* translate to the center of the rendering context and draw a black */
  /* clock outline */
  cairo_set_source_rgba(cr, 0, 0, 0, 1);
  cairo_translate(cr, 0.5, 0.5);
  cairo_arc(cr, 0, 0, 0.4, 0, M_PI * 2);
  cairo_stroke(cr);

  /* draw a white dot on the current second. */
  cairo_set_source_rgba(cr, 1, 1, 1, 0.6);
  cairo_arc(cr, sin(seconds) * 0.4, -cos(seconds) * 0.4, 0.05, 0,
	    M_PI * 2);
  cairo_fill(cr);

  /* draw the minutes indicator */
  cairo_set_source_rgba(cr, 0.2, 0.2, 1, 0.6);
  cairo_move_to(cr, 0, 0);
  cairo_line_to(cr, sin(minutes) * 0.4, -cos(minutes) * 0.4);
  cairo_stroke(cr);

  /* draw the hours indicator      */
  cairo_move_to(cr, 0, 0);
  cairo_line_to(cr, sin(hours) * 0.2, -cos(hours) * 0.2);
  cairo_stroke(cr);
}

gboolean 
tick (gpointer data)
{
  ClutterActor *stage;
  cairo_t *cr;

  stage = clutter_stage_get_default ();
  cr = clutter_cairo_create (CLUTTER_CAIRO (data));

  cairo_scale (cr,
               clutter_actor_get_width (stage),
               clutter_actor_get_height (stage));
  
  drawClock (cr);
  cairo_destroy (cr);

  return TRUE;
}

int
main (int argc, char **argv)
{
  ClutterActor    *ctex, *stage;
  ClutterColor     stage_color = { 0x99, 0xcc, 0xff, 0xff };

  clutter_init (&argc, &argv);

  stage = clutter_stage_get_default ();
  g_signal_connect (stage, "button-press-event",
                    G_CALLBACK (clutter_main_quit),
                    NULL);

  clutter_stage_set_color (CLUTTER_STAGE (stage),
		           &stage_color);

  ctex = clutter_cairo_new (640, 480);

  clutter_group_add (CLUTTER_GROUP(stage), ctex);

  tick (ctex);

  g_timeout_add (1000, tick, ctex);

  clutter_actor_show_all (CLUTTER_ACTOR(stage));

  clutter_main();

  return 1;
}
