#! /bin/sh
#
# This manages the generation of the Visual Studio build files for Windows.
#
# 20041214 larsa

project=coin2

proper=true;

rm -f ${project}.dsp ${project}.dsw ${project}.vcproj ${project}.sln;
rm -f ${project}_install.* ${project}_uninstall.*;
rm -f ${project}_docs.* docs/${project}.doxygen;
rm -f install-headers.bat uninstall-headers.bat;

if $proper; then
  rm -rf src;
fi

build_pwd=`pwd`;
build="`cygpath -w $build_pwd | sed -e 's/\\\\/\\\\\\\\/g'`";
build_pwd="`pwd | sed -e 's/\\//\\\\\\\\/g'`\\\\";

source_pwd=`cd ../..; pwd`;
source="`cygpath -w $source_pwd | sed -e 's/\\\\/\\\\\\\\/g'`";
source_pwd="`(cd ../..; pwd) | sed -e 's/\\//\\\\\\\\/g'`";

if $proper; then
  ../../configure --with-msvcrt=mtd --with-suffix=d \
    --enable-debug --enable-symbols || exit 1;
  mv include/config.h include/config-debug.h;

  ../../configure --enable-msvcdsp --with-msvcrt=mt \
    --disable-debug --disable-symbols --enable-optimization \
    || exit 1;
#   --enable-html --enable-html-help \
#   --enable-3ds-import
  mv include/config.h include/config-release.h;

  cp ../misc/config-wrapper.h include/config.h;
else
  ./config.status --file=cfg/gendsp.pl;
fi

make || exit 1

if $proper; then
  sed \
    -e "s/$build/./g" \
    -e "s/$build_pwd//g" \
    -e "s/$source/..\\\\../g" \
    -e "s/$source_pwd/..\\\\../g" \
    -e 's/$/\r/g' \
    <${project}.dsp >new.dsp

  mv new.dsp ${project}.dsp

  sed \
    -e "s/$build/./g" \
    -e "s/$build_pwd//g" \
    -e "s/$source/..\\\\../g" \
    -e "s/$source_pwd/..\\\\../g" \
    -e 's/$/\r/g' \
    <install-headers.bat >new.bat

  rm install-headers.bat
  mv new.bat ../misc/install-headers.bat

  sed \
    -e "s/$build/./g" \
    -e "s/$build_pwd//g" \
    -e "s/$source/..\\\\../g" \
    -e "s/$source_pwd/..\\\\../g" \
    -e 's/$/\r/g' \
    <uninstall-headers.bat >new.bat

  rm uninstall-headers.bat
  mv new.bat ../misc/uninstall-headers.bat
fi

make docs/coin.doxygen
mv docs/coin.doxygen docs/coin.doxygen.bak
sed \
  -e "s/$build/./g" \
  -e "s/$build_pwd//g" \
  -e "s/$source/..\\\\../g" \
  -e "s/$source_pwd/..\\\\../g" \
  -e "s/GENERATE_HTML.*=.*NO/GENERATE_HTML = YES/g" \
  -e "s/HTML_OUTPUT.*=.*/HTML_OUTPUT = ..\\\\html/g" \
  -e 's/$/\r/g' \
  <docs/coin.doxygen.bak >docs/${project}.doxygen

echo "Done."
echo "Make sure the ${project}.dsp file does not contain any absolute paths."
echo "Here are some indicator tests."
echo ""

set -x
grep -i "\\(c:\\|@\\)" ${project}.dsp /dev/null
grep -i "cygdrive" ${project}.dsp /dev/null
grep "svn" ${project}.dsp /dev/null
sort ../misc/install-headers.bat | uniq -c | grep -v " 1 "
sort ../misc/uninstall-headers.bat | uniq -c | grep -v " 1 "
grep "SOURCE=" ${project}.dsp | sort | uniq -c | grep -v " 1 "
set +x

echo ""
echo "If everything seems OK, upgrade the project files with devenv if necessary."

