/*
   Common Routines
   --------------------------------------------------------------------
   Country Codes

   Copyright (C) 1999, 2000 Diego Javier Grigna <diego@grigna.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

/* The program name, argv[ 0] */
char *progname;

char *cc_basename( char *name)
{
 char *base;

 if( name == NULL) {
     fprintf( stderr, "\n%s: cc_basename called with NULL argument\n\n", progname);
     exit( -1);
 }

 base = strrchr( name, '/');

 return ( ( base != NULL) ? base + 1 : name);
}

void cc_lowercase( char *str)
{
 char *a = str;

 while( a && *a) {
        *a = tolower( *a);
        a++;
 } 

}

char *cc_hyp( void)
{
 static char hyp[ 128];

 memset( &hyp, '-', 77);
 hyp[ 77] = 0;

 return hyp;
}

