/* utilities.notepad.c - a text area for user notes
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank-interface.h"

/* Global variables */

/* Fn Declarations */
static GtkWidget *make_notepad(void);

/* Plugin Interface */
/* ---------------- */

const char name[] = "utilities.notepad";
const char version[] = VERSION;
const char author[] = "Matthew Russell";
const char description[] = "A notepad for temporary workings-out.";
const int interface_version = 1;
const int plugin_type = PLUGIN_FLOATING;
const char menu_string[] = "/Utilities/Notepad";

int boot(void) {
    return PLUGIN_BOOT_OK;
}

GtkWidget *make_widget(char *text) {
    return make_notepad();
}

/* Plugin Implementation */
/* --------------------- */

static GtkWidget *make_notepad(void) {
    GtkWidget *dialog;
    GtkWidget *button;
    GtkWidget *notepad;
    dialog  = gtk_dialog_new();
    gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
    gtk_widget_set_usize(dialog, -1, -1);
    gtk_window_set_title(GTK_WINDOW(dialog), "Notepad");
    button = gtk_button_new_with_label("Dismiss");
    gtk_signal_connect_object(GTK_OBJECT(button),
			      "clicked",
			      (GtkSignalFunc) gtk_widget_destroy,
			      GTK_OBJECT(dialog));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
    notepad = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(notepad), TRUE);
    gtk_text_set_word_wrap(GTK_TEXT(notepad), TRUE);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), notepad, TRUE, TRUE, 0);
    gtk_widget_show(notepad);
    return dialog;
}

/* Callbacks */
/* --------- */
