/* This file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004,2005 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CCC_CANVAS_PRIV_H
#define CCC_CANVAS_PRIV_H

#include <glib-object.h>

G_BEGIN_DECLS

struct _CriaCanvas {
	GnomeCanvas	  canvas;
	CcRectangle	* extents;
	gdouble		  zoom;
	guint64		  padding;
};

struct _CriaCanvasClass {
	GnomeCanvasClass  canvas_class;

	gboolean (*focus_changed)      (CriaCanvas	* self,
					CriaItem	* new_focus);
};

struct _CriaItem {
	GnomeCanvasGroup  group;
	CriaItem	* focused_child;
	CriaItemFlags     item_flags;
};

struct _CriaItemClass {
	GnomeCanvasGroupClass  group_class;

	/* signals */
	gboolean (*button_press_event) (CriaItem    	* self,
					GdkEventButton	* event);
	gboolean (*focus)	       (CriaItem	* self,
					GtkDirectionType  dir);
	gboolean (*focus_in_event)     (CriaItem        * self,
					GdkEventFocus   * event);
	gboolean (*focus_out_event)    (CriaItem	* self,
					GdkEventFocus   * event);
	void     (*grab_focus)	       (CriaItem	* self);
	gboolean (*key_press_event)    (CriaItem        * self,
					GdkEventKey     * event);
};

#define CRIA_ITEM_FLAGS(item)		 (CRIA_ITEM(item)->item_flags)
#define CRIA_ITEM_CAN_FOCUS(item)        ((CRIA_ITEM_FLAGS(item) & CRIA_CAN_FOCUS) != 0)
#define CRIA_ITEM_IS_INTERACTIVE(item)   ((CRIA_ITEM_FLAGS(item) & CRIA_INTERACTIVE) != 0)
#define CRIA_ITEM_SET_FLAG(item, flag)   G_STMT_START{ (CRIA_ITEM_FLAGS(item) |= (flag)); }G_STMT_END
#define CRIA_ITEM_UNSET_FLAG(item, flag) G_STMT_START{ (CRIA_ITEM_FLAGS(item) &= ~(flag)); }G_STMT_END

G_END_DECLS

#endif /* !CCC_CANVAS_PRIV_H */
