/*
 *  declarations for config-table & mount-table utilities for cryptmount
 *  $Revision: 161 $, $Date: 2007-05-05 22:53:24 +0100 (Sat, 05 May 2007) $
 *  Copyright 2005-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _TABLES_H
#define _TABLES_H


struct cment;

typedef struct tgtstat
{
    char *ident;            /* unique identifying name of target */
    unsigned long uid;      /* user-ID responsible for mounting filesystem */

    struct tgtstat *nx;     /* form into linked list */
} tgtstat_t;


struct cment *alloc_cment(void);
const struct cment *get_cment(const struct cment *head, const char *ident);
void free_cment(struct cment *ent);

struct cment *parse_config(const char *cfgname);
struct cment *parse_config_fd(int fd);
void free_config(struct cment **head);

tgtstat_t *alloc_tgtstatus(const struct cment *ent);
tgtstat_t *get_tgtstatus(const struct cment *ent);
tgtstat_t *get_all_tgtstatus();
int put_tgtstatus(const struct cment *ent, const tgtstat_t *tstat);
void free_tgtstatus(tgtstat_t *tstat);

#endif  /* _TABLES_H */

/*
 *  tables.h
 *  (C)Copyright 2005-2007, RW Penney
 */
