/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "Utils.hh"

#include "AddressBook.hh"


/**
 * AddressBook 
 */



namespace Cryptonit
{

    AddressBook::AddressBook()
    {
	addressBook = new DirectoryService();
    } 
    
    
    AddressBook::AddressBook( const std::string uri )
    {

#ifdef DEBUG
      std::cerr << "Print URI ====>" << uri << std::endl;
#endif
	addressBook = addressBook->factory( uri );

	std::string params[] = {"", ""};
	std::string filename = "";

	if( ! addressBook->read( params ) ) {
#ifdef DEBUG
 	    std::cerr << "Cannot load address book '"<< uri <<"'."<<std::endl;
 	    std::cerr << "Retry with default filename" << std::endl;
#endif 

	    /* Retry with the default filename */
	    filename = appendDir( uri, ADDRESSBOOK_DEFAULT_FILENAME );

	    if( ! addressBook->read( params ) ) {
#ifdef DEBUG
 		std::cerr << "Cannot load address book '"<< uri <<"'."<<std::endl;
#endif 
		delete addressBook;
		addressBook = NULL;
		return;
	    }
	}

#ifdef DEBUG
 	std::cerr << "Address book loaded from '" << (filename == "" ? uri : filename) <<"'." << std::endl;
 	std::cerr << addressBook->getNbEntry() << " contact(s) added." << std::endl;
#endif 
    } 


    AddressBook::~AddressBook()
    {
	if( addressBook )
	    delete addressBook;
    }

    
    bool AddressBook::save( const std::string fileName )
    {
	std::string params[] = { fileName, ""};
	return addressBook->commit( params );
    }


    bool AddressBook::addContact( Contact& contact )
    {
	Entry* infos = new Entry( contact.getInfo() );
	return addressBook->append( contact.getName(), infos );
    }


    bool AddressBook::addContact( Contact* contact )
    {
	Entry* infos = new Entry( contact->getInfo() );
	return addressBook->append( contact->getName(), infos );
    }


    bool AddressBook::removeContact( const std::string name )
    {
	return addressBook->erase( name );
    }


    Contact* AddressBook::getContact( const std::string name )
    {
	return NULL;
    }


    Entry* AddressBook::getContactDSE( const std::string name )
    {
	return addressBook->getEntry( name );
    }


    std::vector<std::string>* AddressBook::getAllContactName()
    {
	std::vector<std::string>* result = new std::vector<std::string>();

	if( addressBook != NULL ) {
	    DirectoryService::iterator itr = addressBook->begin();

	    while( itr != addressBook->end() ) {
		result->push_back( itr.first() );
		itr++;
	    }
	    return result;
	}
	else return NULL;
    }


    std::string AddressBook::getContactInfo( const std::string name, const std::string infoName )
    {
	if( addressBook != NULL ) {
	    if( name != "" && ContactInfo::isInfoSupported( infoName ) ) {

		Entry* entry = addressBook->getEntry( name );

		if( entry != NULL )
		    return( entry->getAttributeFirstValue( infoName ) );
	    }
	}
	return( std::string("") );
    }
    

    std::vector<std::string> AddressBook::getContactInfos( const std::string name, const std::string infoName )
    {
	if( addressBook != NULL ) {
	    if( name != "" && ContactInfo::isInfoSupported( infoName ) ) {

		Entry* entry = addressBook->getEntry( name );

		if( entry != NULL )
		    return( entry->getAttributeValues( name ) );
	    }
	}
	return std::vector<std::string>(0);
    }

}
