/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "P11Error.hh"


// allow for translations of the error messages
#ifdef TEMP_USE_GETTEXT
#define GGTXT(x) _(x)
#else
#define GGTXT(x) x
#endif

namespace Cryptonit
{

void P11Error::checkRV(CK_RV rv)
{
	switch(rv)
	{
	
	/* when possible, try to keep this list sorted in descending
	occurring frequency order. */
	
	case CKR_OK : {break;} // placed first to speed up normal events
	
	// example :
	/* case PKCS11_Error_Code : {
		newMessage(type,
		GGTXT("title"),
		GGTXT("explanation"));
		break;} */
	
	
	case CKR_PIN_INCORRECT : {
		newMessage(P11E_ERROR,
		GGTXT("PIN incorrect !"),
		GGTXT("Check that you are entering your Personal Identification \
Number. Also, please remember that the number of retries are limited \
before the device is locked."));
		break;}
	
	case CKR_PIN_LOCKED : {
		newMessage(P11E_ERROR,
		GGTXT("PIN locked !"),
		GGTXT("The PIN is locked, due to a number of failed login attempts. \
Please ask the Security Officer to change the PIN."));
		break;}
	
	case CKR_USER_NOT_LOGGED_IN : {
		newMessage(P11E_ERROR,
		GGTXT("User not logged in."),
		GGTXT("The desired action cannot be performed because the appropriate \
user is not logged in."));
		break;}
	
	case CKR_USER_PIN_NOT_INITIALIZED : {
		newMessage(P11E_ERROR,
		GGTXT("User PIN not initialized"),
		GGTXT(""));
		break;}
	
	case CKR_TOKEN_NOT_PRESENT : {
		newMessage(P11E_ERROR,
		GGTXT("Token not present."),
		GGTXT("Check that the token is correctly inserted in the device."));
		break;}
	
	case CKR_DEVICE_REMOVED : {
		newMessage(P11E_ERROR,
		GGTXT("Device removed."),
		GGTXT("Try to insert again the token in the reader."));
		break;}
	
	case CKR_DEVICE_ERROR : {
		newMessage(P11E_ERROR,
		GGTXT("The accessed device caused an undefined error."),
		GGTXT(""));
		break;}
	
	case CKR_DEVICE_MEMORY : {
		newMessage(P11E_ERROR,
		GGTXT("The accessed device had a memory error."),
		GGTXT(""));
		break;}
	
	case CKR_USER_ALREADY_LOGGED_IN : {
		newMessage(P11E_INFO,
		GGTXT("The user is already logged in."),
		GGTXT("There is no need to login again."));
		break;}
		
	case CKR_USER_ANOTHER_ALREADY_LOGGED_IN : {
		newMessage(P11E_ERROR,
		GGTXT("Another user is already logged in."),
		GGTXT(""));
		break;}
	
	case CKR_USER_TOO_MANY_TYPES : {
		newMessage(P11E_ERROR,
		GGTXT("Too many types of users try to log in."),
		GGTXT("An attempt was made to have more distint types of users \
simultaneously logged into the token than the token and/or \
library permits."));
		break;}
	
	case CKR_SESSION_HANDLE_INVALID : {
		newMessage(P11E_ERROR,
		GGTXT("Session handle invalid."),
		GGTXT("An operation has failed because the session is not \
available."));
		break;}
	
	case CKR_SESSION_EXISTS : {
		newMessage(P11E_ERROR,
		GGTXT("The session already exists."),
		GGTXT("A session with the token is already open, and so \
the token cannot be initialized."));
		break;}
	
	case CKR_SESSION_READ_ONLY : {
		newMessage(P11E_ERROR,
		GGTXT("Session is read-only."),
		GGTXT("The session was unable to accomplish the desired action \
because is it a read-only session."));
		break;}
	
	case CKR_SESSION_READ_ONLY_EXISTS : {
		newMessage(P11E_ERROR,
		GGTXT("A read-only session exists."),
		GGTXT("As a consequence, the SO cannot be logged in."));
		break;}
	
	case CKR_SESSION_READ_WRITE_SO_EXISTS : {
		newMessage(P11E_ERROR,
		GGTXT("A read/write SO session already exists."),
		GGTXT("As a consequence, a read-only session cannot be opened."));
		break;}
	
	case CKR_ARGUMENTS_BAD : {
		newMessage(P11E_ERROR,
		GGTXT("Internal error in the PKCS#11 module."),
		GGTXT("A PKCS#11 function was given bad arguments."));
		break;}
	
	case CKR_OBJECT_HANDLE_INVALID : {
		newMessage(P11E_ERROR,
		GGTXT("Object handle invalid."),
		GGTXT("The program could not access the specified object."));
		break;}
	
	case CKR_CRYPTOKI_ALREADY_INITIALIZED : {
		newMessage(P11E_ERROR,
		GGTXT("The PKCS#11 Cryptoki is already initialized."),
		GGTXT(""));
		break;}
	
	case CKR_CRYPTOKI_NOT_INITIALIZED : {
		newMessage(P11E_ERROR,
		GGTXT("The PKCS#11 Cryptoki library is not initialized."),
		GGTXT("Please check that you have installed the necessary PKCS#11 \
module and device drivers."));
		break;}
	
	case CKR_SLOT_ID_INVALID : {
		newMessage(P11E_ERROR,
		GGTXT("The specified slot ID is invalid."),
		GGTXT(""));
		break;}
	
	case CKR_SESSION_CLOSED : {
		newMessage(P11E_ERROR,
		GGTXT("The session was closed during the execution of a function."),
		GGTXT(""));
		break;}
	
	
	
	
	
	
	default : {
		newMessage(P11E_INFO,
		GGTXT("An unknown error has occurred."),
		GGTXT(""));
		break;}
	}
}

} // namespace Cryptonit
