#!/usr/bin/perl
use strict;

my $name = shift @ARGV;
my $file = shift @ARGV;

open(FILE, "$file");
my $content = join '', <FILE>;
close(FILE);

my @bytes = unpack("C*", $content);
my @bytes = map { sprintf "0x%02x", $_ => $_ } @bytes;

my $size = scalar(@bytes);

my @lines;
while(@bytes) {
	push @lines, join ", ", (splice @bytes, 0, 8);
}

print "unsigned char $name [$size] = {\n\t";
print join ",\n\t", @lines;
print "\n};\n"
