/* tbvcf.orc */
;---------------------------------------------------------
; TBVCF Test
; Coded by Hans Mikelson December, 2000
;---------------------------------------------------------
  sr =  44100   ; Sample rate
  kr =  4410   ; Kontrol rate
  ksmps =  10   ; Samples/Kontrol period
  nchnls =  2        ; Normal stereo
  zakinit 50, 50

          instr 10

  idur    =          p3                                ; Duration
  iamp    =          p4                                ; Amplitude
  ifqc    =          cpspch(p5)                        ; Pitch to frequency
  ipanl   =          sqrt(p6)                          ; Pan left
  ipanr   =          sqrt(1-p6)                        ; Pan right
  iq      =          p7
  idist   =          p8
  iasym   =          p9

  kdclck  linseg 0, .002, 1, idur-.004, 1, .002, 0 ; Declick envelope

  kfco    expseg 10000, idur, 1000                 ; Frequency envelope

  ax      vco 1, ifqc, 2, 1                     ; Square wave
  ay      tbvcf ax, kfco, iq, idist, iasym        ; TB-VCF
  ay      buthp ay/1, 100                         ; Hi-pass

          outs ay*iamp*ipanl*kdclck, ay*iamp*ipanr*kdclck
          endin
/* tbvcf.orc */
