! UIMX ascii 2.5 key: 9100                                                      

*applicationShell1.class: applicationShell
*applicationShell1.gbldecl: /*\
          Copyright (C) 1993, 1994, RSNA and Washington University\
 \
          The software and supporting documentation for the Radiological\
          Society of North America (RSNA) 1993, 1994 Digital Imaging and\
          Communications in Medicine (DICOM) Demonstration were developed\
          at the\
                  Electronic Radiology Laboratory\
                  Mallinckrodt Institute of Radiology\
                  Washington University School of Medicine\
                  510 S. Kingshighway Blvd.\
                  St. Louis, MO 63110\
          as part of the 1993, 1994 DICOM Central Test Node project for, and\
          under contract with, the Radiological Society of North America.\
 \
          THIS SOFTWARE IS MADE AVAILABLE, AS IS, AND NEITHER RSNA NOR\
          WASHINGTON UNIVERSITY MAKE ANY WARRANTY ABOUT THE SOFTWARE, ITS\
          PERFORMANCE, ITS MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR\
          USE, FREEDOM FROM ANY COMPUTER DISEASES OR ITS CONFORMITY TO ANY\
          SPECIFICATION. THE ENTIRE RISK AS TO QUALITY AND PERFORMANCE OF\
          THE SOFTWARE IS WITH THE USER.\
 \
          Copyright of the software and supporting documentation is\
          jointly owned by RSNA and Washington University, and free access\
          is hereby granted as a license to use this software, copy this\
          software and prepare derivative works based upon this software.\
          However, any distribution of this software source code or\
          supporting documentation or derivative works (source code and\
          supporting documentation) must include the three paragraphs of\
          the copyright notice.\
*/\
/* Copyright marker.  Copyright will be inserted above.  Do not remove */\
\
/*\
**                   Electronic Radiology Laboratory\
**                 Mallinckrodt Institute of Radiology\
**              Washington University School of Medicine\
**\
** Module Name(s):	interface support functions\
**			widget creation functions\
**			widget callback functions\
** Author, Date:	Steve Moore, Summer 1994\
** Intent:		This file contains the main part of the image\
**			database (idb) viewer application.  It contains\
**			the code generated by the interface builder to\
**			provide the user interface as well as the code\
**			that we added that actually does the work (like\
**			searching through the database and displaying\
**			records.\
** Last Update:         $Author: smm $, $Date: 1995/12/19 15:22:23 $\
** Source File:         $RCSfile: applicationShell1.i,v $\
** Revision:            $Revision: 1.5 $\
** Status:              $State: Exp $\
*/\
 \
static char rcsid[] = "$Revision: 1.5 $ $RCSfile: applicationShell1.i,v $";\
\
#include <stdio.h>\
#include <stdlib.h>\
\
#include "dicom.h"\
#include "condition.h"\
#include "lst.h"\
#include "dicom_objects.h"\
#include "tbl.h"\
#include "idb.h"\
#include "mut.h"\
\
#include "idb_viewer.h"\
#include "format.h"\
\
extern IDB_HANDLE *IDBHandle;\
\
static LST_HEAD *patientList = NULL;\
static LST_HEAD *studyList = NULL;\
static LST_HEAD *seriesList = NULL;\
static LST_HEAD *imageList = NULL;\
static int displayLevel = 0;\

*applicationShell1.ispecdecl:
*applicationShell1.funcdecl: swidget create_applicationShell1(swidget UxParent)
*applicationShell1.funcname: create_applicationShell1
*applicationShell1.funcdef: "swidget", "<create_applicationShell1>(%)"
*applicationShell1.argdecl: swidget UxParent;
*applicationShell1.arglist: UxParent
*applicationShell1.arglist.UxParent: "swidget", "%UxParent%"
*applicationShell1.icode:
*applicationShell1.fcode: return(rtrn);\

*applicationShell1.auxdecl: static CONDITION copyInstances(IDB_Query *src, IDB_Query *dst)\
{\
  IDB_InstanceListElement *e1, *e2;\
\
    dst->image.InstanceList = NULL;\
    if (src->image.InstanceList != NULL) {\
	dst->image.InstanceList = LST_Create();\
	if (dst->image.InstanceList == NULL)\
	    return 0;\
\
	e1 = LST_Head(&src->image.InstanceList);\
	(void) LST_Position(&src->image.InstanceList, e1);\
\
/* Insert an extra one at the beginning */\
\
	if (e1 != NULL) {\
	    e2 = malloc(sizeof(*e2));\
	    *e2 = *e1;\
	    (void) LST_Enqueue(&dst->image.InstanceList, e2);\
	}\
\
/* Insert all copies of instances */\
\
	while (e1 != NULL) {\
	    e2 = malloc(sizeof(*e2));\
	    *e2 = *e1;\
	    (void) LST_Enqueue(&dst->image.InstanceList, e2);\
	    e1 = LST_Next(&src->image.InstanceList);\
	}\
    }\
    return 1;\
}\
\
\
static CONDITION\
selectCallback(IDB_Query *q, long count, LST_HEAD *lst)\
{\
  QUERY_LIST_ITEM *item;\
\
    item = malloc(sizeof(*item));\
    if (item == NULL)\
	return 0;\
\
    item->query = *q;\
    if (copyInstances(q, &item->query) != 1)\
	return 0;\
\
    (void) LST_Enqueue(&lst, item);\
    if (count == 1) { /* Add another record */\
	item = malloc(sizeof(*item));\
	if (item == NULL)\
	    return 0;\
\
	item->query = *q;\
	if (copyInstances(q, &item->query) != 1)\
	    return 0;\
	(void) LST_Enqueue(&lst, item);\
    }\
\
    return IDB_NORMAL;\
}\
\
static CONDITION createLists()\
{\
    if (patientList == NULL)\
	patientList = LST_Create();\
    if (studyList == NULL)\
	studyList = LST_Create();\
    if (seriesList == NULL)\
	seriesList = LST_Create();\
    if (imageList == NULL)\
	imageList = LST_Create();\
\
    if (patientList == NULL)\
	return 0;\
    if (studyList == NULL)\
	return 0;\
    if (seriesList == NULL)\
	return 0;\
    if (imageList == NULL)\
	return 0;\
\
    return 1;\
}\
\
static void clearList(LST_HEAD *l)\
{\
  QUERY_LIST_ITEM *item;\
\
    while ((item = LST_Dequeue(&l)) != NULL)\
	free (item);\
}\
\
void loadPatient()\
{\
  CONDITION cond;\
  char b[256];\
  IDB_Query queryStructure;\
  long selectCount;\
\
    if (createLists() == 0)\
	return;\
\
    clearList(patientList);\
    memset(&queryStructure, 0, sizeof(queryStructure));\
    cond = IDB_Select(&IDBHandle, PATIENT_ROOT, IDB_PATIENT_LEVEL,\
	IDB_PATIENT_LEVEL, &queryStructure, &selectCount,\
	selectCallback, patientList);\
    if (cond != IDB_NORMAL && cond != IDB_NOMATCHES) {\
	COND_DumpConditions();\
	return;\
    }\
    MUT_LoadList(wObjectList, patientList, formatPatient, b);\
    XmTextSetString(wPatientTxt, "");\
    XmTextSetString(wStudyTxt, "");\
    XmTextSetString(wSeriesTxt, "");\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
    displayLevel = IDB_PATIENT_LEVEL;\
}\
\
static void displayPatient(QUERY_LIST_ITEM *item)\
{\
  char buf[256];\
\
    formatPatient(item, 2, buf);\
    XmTextSetString(wPatientTxt, buf);\
    XmTextSetString(wStudyTxt, "");\
    XmTextSetString(wSeriesTxt, "");\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
}\
\
static void loadStudy(char *patientID)\
{\
  CONDITION cond;\
  char b[256];\
  IDB_Query query;\
  long selectCount;\
\
    if (createLists() == 0)\
	return;\
\
    clearList(studyList);\
    memset(&query, 0, sizeof(query));\
    query.PatientQFlag = QF_PAT_PatID;\
    strcpy(query.patient.PatID, patientID);\
    cond = IDB_Select(&IDBHandle, PATIENT_ROOT, IDB_PATIENT_LEVEL,\
	IDB_STUDY_LEVEL, &query, &selectCount,\
	selectCallback, studyList);\
    if (cond != IDB_NORMAL && cond != IDB_NOMATCHES) {\
	COND_DumpConditions();\
	return;\
    }\
    MUT_LoadList(wObjectList, studyList, formatStudy, b);\
    XmTextSetString(wStudyTxt, "");\
    XmTextSetString(wSeriesTxt, "");\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
    displayLevel = IDB_STUDY_LEVEL;\
}\
\
static void displayStudy(QUERY_LIST_ITEM *item)\
{\
  char buf[256];\
\
    formatStudy(item, 2, buf);\
    XmTextSetString(wStudyTxt, buf);\
    XmTextSetString(wSeriesTxt, "");\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
}\
\
static void loadSeries(char *patientID, char *studyInstanceUID)\
{\
  CONDITION cond;\
  char b[256];\
  IDB_Query query;\
  long selectCount;\
\
    if (createLists() == 0)\
	return;\
\
    clearList(seriesList);\
    memset(&query, 0, sizeof(query));\
    query.PatientQFlag = QF_PAT_PatID;\
    query.StudyQFlag = QF_STU_StuInsUID;\
    strcpy(query.patient.PatID, patientID);\
    strcpy(query.study.StuInsUID, studyInstanceUID);\
    cond = IDB_Select(&IDBHandle, PATIENT_ROOT, IDB_PATIENT_LEVEL,\
	IDB_SERIES_LEVEL, &query, &selectCount,\
	selectCallback, seriesList);\
    if (cond != IDB_NORMAL && cond != IDB_NOMATCHES) {\
	COND_DumpConditions();\
	return;\
    }\
    MUT_LoadList(wObjectList, seriesList, formatSeries, b);\
    XmTextSetString(wSeriesTxt, "");\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
    displayLevel = IDB_SERIES_LEVEL;\
}\
\
static void displaySeries(QUERY_LIST_ITEM *item)\
{\
  char buf[256];\
\
    formatSeries(item, 2, buf);\
    XmTextSetString(wSeriesTxt, buf);\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
}\
\
static void loadImage(char *patientID, char *studyInstanceUID,\
	char *seriesInstanceUID)\
{\
  CONDITION cond;\
  char b[256];\
  IDB_Query query;\
  long selectCount;\
\
    if (createLists() == 0)\
	return;\
\
    clearList(imageList);\
    memset(&query, 0, sizeof(query));\
    query.PatientQFlag = QF_PAT_PatID;\
    query.StudyQFlag = QF_STU_StuInsUID;\
    query.SeriesQFlag = QF_SER_SerInsUID;\
    strcpy(query.patient.PatID, patientID);\
    strcpy(query.study.StuInsUID, studyInstanceUID);\
    strcpy(query.series.SerInsUID, seriesInstanceUID);\
    cond = IDB_Select(&IDBHandle, PATIENT_ROOT, IDB_PATIENT_LEVEL,\
	IDB_IMAGE_LEVEL, &query, &selectCount,\
	selectCallback, imageList);\
    if (cond != IDB_NORMAL && cond != IDB_NOMATCHES) {\
	COND_DumpConditions();\
	return;\
    }\
    MUT_LoadList(wObjectList, imageList, formatImage, b);\
    XmTextSetString(wImageTxt, "");\
    XmTextSetString(wInstanceTxt, "");\
    displayLevel = IDB_IMAGE_LEVEL;\
}\
\
static void displayImage(QUERY_LIST_ITEM *item)\
{\
  char buf[256];\
\
    formatImage(item, 2, buf);\
    XmTextSetString(wImageTxt, buf);\
    XmTextSetString(wInstanceTxt, "");\
}\
\
static void loadInstance(LST_HEAD *instanceList)\
{\
  char b[256];\
\
    MUT_LoadList(wObjectList, instanceList, formatInstance, b);\
    XmTextSetString(wInstanceTxt, "");\
    displayLevel = IDB_IMAGE_LEVEL + 1;\
}\
\
static void displayInstance(IDB_InstanceListElement *item)\
{\
  char buf[256];\
\
    formatInstance(item, 2, buf);\
    XmTextSetString(wInstanceTxt, buf);\
}
*applicationShell1.static: true
*applicationShell1.name: applicationShell1
*applicationShell1.parent: NO_PARENT
*applicationShell1.parentExpression: UxParent
*applicationShell1.width: 710
*applicationShell1.height: 450
*applicationShell1.isCompound: "true"
*applicationShell1.compoundIcon: "applS.xpm"
*applicationShell1.compoundName: "appl_Shell"
*applicationShell1.x: 183
*applicationShell1.y: 119

*mainWindow1.class: mainWindow
*mainWindow1.static: true
*mainWindow1.name: mainWindow1
*mainWindow1.parent: applicationShell1
*mainWindow1.width: 710
*mainWindow1.height: 450
*mainWindow1.isCompound: "true"
*mainWindow1.compoundIcon: "main.xpm"
*mainWindow1.compoundName: "main_Window"
*mainWindow1.compoundEditor: {\
extern swidget UxGUIMePopup UXPROTO((swidget, swidget, int, int));\
UxGUIMwePopup(UxThisWidget, UxGetParent(UxThisWidget));\
}
*mainWindow1.x: 80
*mainWindow1.y: 40
*mainWindow1.unitType: "pixels"

*menu1.class: rowColumn
*menu1.static: true
*menu1.name: menu1
*menu1.parent: mainWindow1
*menu1.rowColumnType: "menu_bar"
*menu1.menuAccelerator: "<KeyUp>F10"

*menu1_p1.class: rowColumn
*menu1_p1.static: true
*menu1_p1.name: menu1_p1
*menu1_p1.parent: menu1
*menu1_p1.rowColumnType: "menu_pulldown"

*menu1_p1_b1.class: pushButton
*menu1_p1_b1.static: true
*menu1_p1_b1.name: menu1_p1_b1
*menu1_p1_b1.parent: menu1_p1
*menu1_p1_b1.labelString: "Quit"
*menu1_p1_b1.activateCallback: {\
    exit(0);\
}

*menu1_top_b1.class: cascadeButton
*menu1_top_b1.static: true
*menu1_top_b1.name: menu1_top_b1
*menu1_top_b1.parent: menu1
*menu1_top_b1.labelString: "Control"
*menu1_top_b1.subMenuId: "menu1_p1"

*form1.class: form
*form1.static: true
*form1.name: form1
*form1.parent: mainWindow1

*frame1.class: frame
*frame1.static: true
*frame1.name: frame1
*frame1.parent: form1
*frame1.width: 560
*frame1.height: 150
*frame1.isCompound: "true"
*frame1.compoundIcon: "frame.xpm"
*frame1.compoundName: "frame_"
*frame1.x: 20
*frame1.y: 10
*frame1.resizable: "false"

*scrolledWindowList1.class: scrolledWindow
*scrolledWindowList1.static: true
*scrolledWindowList1.name: scrolledWindowList1
*scrolledWindowList1.parent: frame1
*scrolledWindowList1.scrollingPolicy: "application_defined"
*scrolledWindowList1.visualPolicy: "variable"
*scrolledWindowList1.scrollBarDisplayPolicy: "static"
*scrolledWindowList1.shadowThickness: 0
*scrolledWindowList1.isCompound: "true"
*scrolledWindowList1.compoundIcon: "scrllist.xpm"
*scrolledWindowList1.compoundName: "scrolled_List"
*scrolledWindowList1.x: 110
*scrolledWindowList1.y: 60

*wObjectList.class: scrolledList
*wObjectList.static: true
*wObjectList.name: wObjectList
*wObjectList.parent: scrolledWindowList1
*wObjectList.width: 130
*wObjectList.height: 30
*wObjectList.browseSelectionCallback: {\
  XmListCallbackStruct *listStruct;\
  QUERY_LIST_ITEM *item;\
  IDB_InstanceListElement *instance;\
\
    listStruct = (XmListCallbackStruct *)UxCallbackArg;\
\
    if (listStruct->item_position == 1) {\
	switch(displayLevel) {\
	case IDB_PATIENT_LEVEL:\
	    loadPatient();\
	    break;\
	case IDB_STUDY_LEVEL:\
	    loadPatient();\
	    break;\
	case IDB_SERIES_LEVEL:\
	    item = LST_Current(&studyList);\
	    loadStudy(item->query.patient.PatID);\
	    break;\
	case IDB_IMAGE_LEVEL:\
	    item = LST_Current(&seriesList);\
	    loadSeries(item->query.patient.PatID,\
		item->query.study.StuInsUID);\
	    break;\
	case IDB_IMAGE_LEVEL + 1:\
	    item = LST_Current(&imageList);\
	    loadImage(item->query.patient.PatID,\
		item->query.study.StuInsUID,\
		item->query.series.SerInsUID);\
	    break;\
	default:\
	    break;\
	}\
    } else {\
	switch(displayLevel) {\
	case IDB_PATIENT_LEVEL:\
	    item = LST_Index(&patientList, listStruct->item_position);\
	    loadStudy(item->query.patient.PatID);\
	    displayPatient(item);\
	    break;\
	case IDB_STUDY_LEVEL:\
	    item = LST_Index(&studyList, listStruct->item_position);\
	    loadSeries(item->query.patient.PatID,\
		item->query.study.StuInsUID);\
	    displayStudy(item);\
	    break;\
	case IDB_SERIES_LEVEL:\
	    item = LST_Index(&seriesList, listStruct->item_position);\
	    loadImage(item->query.patient.PatID,\
		item->query.study.StuInsUID,\
		item->query.series.SerInsUID);\
	    displaySeries(item);\
	    break;\
	case IDB_IMAGE_LEVEL:\
	    item = LST_Index(&imageList, listStruct->item_position);\
	    loadInstance(item->query.image.InstanceList);\
	    displayImage(item);\
	    break;\
	case IDB_IMAGE_LEVEL + 1:\
	    item = LST_Current(&imageList);\
	    instance = LST_Index(&item->query.image.InstanceList,\
		listStruct->item_position);\
	    displayInstance(instance);\
	    break;\
	default:\
	    break;\
	}\
    }\
}

*pushButton1.class: pushButton
*pushButton1.static: true
*pushButton1.name: pushButton1
*pushButton1.parent: form1
*pushButton1.isCompound: "true"
*pushButton1.compoundIcon: "push.xpm"
*pushButton1.compoundName: "push_Button"
*pushButton1.x: 600
*pushButton1.y: 60
*pushButton1.width: 100
*pushButton1.height: 50
*pushButton1.labelString: "Delete"
*pushButton1.activateCallback: {\
  CONDITION cond;\
  char *uid = NULL;\
  QUERY_LIST_ITEM *item;\
\
    switch(displayLevel) {\
	case IDB_PATIENT_LEVEL + 1:\
	    item = LST_Current(&patientList);\
	    uid = item->query.patient.PatID;\
	    break;\
	case IDB_STUDY_LEVEL + 1:\
	    item = LST_Current(&studyList);\
	    uid = item->query.study.StuInsUID;\
	    break;\
	case IDB_SERIES_LEVEL + 1:\
	    item = LST_Current(&seriesList);\
	    uid = item->query.series.SerInsUID;\
	    break;\
	case IDB_IMAGE_LEVEL + 1:\
	    item = LST_Current(&imageList);\
	    uid = item->query.image.SOPInsUID;\
	    break;\
    }\
\
    if (uid != NULL) {\
	cond = IDB_Delete(&IDBHandle, displayLevel - 1, uid, TRUE);\
	if (cond != IDB_NORMAL)\
	    COND_DumpConditions();\
\
	loadPatient();\
    }\
\
}

*label1.class: label
*label1.static: true
*label1.name: label1
*label1.parent: form1
*label1.isCompound: "true"
*label1.compoundIcon: "label.xpm"
*label1.compoundName: "label_"
*label1.x: 30
*label1.y: 180
*label1.width: 110
*label1.height: 30
*label1.labelString: "Patient"

*label2.class: label
*label2.static: true
*label2.name: label2
*label2.parent: form1
*label2.isCompound: "true"
*label2.compoundIcon: "label.xpm"
*label2.compoundName: "label_"
*label2.x: 30
*label2.y: 230
*label2.width: 110
*label2.height: 30
*label2.leftAttachment: "attach_opposite_widget"
*label2.leftOffset: 0
*label2.leftWidget: "label1"
*label2.topAttachment: "attach_widget"
*label2.topOffset: 15
*label2.topWidget: "label1"
*label2.labelString: "Study"

*label3.class: label
*label3.static: true
*label3.name: label3
*label3.parent: form1
*label3.isCompound: "true"
*label3.compoundIcon: "label.xpm"
*label3.compoundName: "label_"
*label3.x: 30
*label3.y: 270
*label3.width: 110
*label3.height: 30
*label3.leftAttachment: "attach_opposite_widget"
*label3.leftOffset: 0
*label3.leftWidget: "label1"
*label3.topAttachment: "attach_widget"
*label3.topOffset: 15
*label3.topWidget: "label2"
*label3.labelString: "Series"

*label4.class: label
*label4.static: true
*label4.name: label4
*label4.parent: form1
*label4.isCompound: "true"
*label4.compoundIcon: "label.xpm"
*label4.compoundName: "label_"
*label4.x: 40
*label4.y: 310
*label4.width: 110
*label4.height: 30
*label4.leftAttachment: "attach_opposite_widget"
*label4.leftOffset: 0
*label4.leftWidget: "label1"
*label4.topAttachment: "attach_widget"
*label4.topOffset: 15
*label4.topWidget: "label3"
*label4.labelString: "Image"

*wPatientTxt.class: textField
*wPatientTxt.static: true
*wPatientTxt.name: wPatientTxt
*wPatientTxt.parent: form1
*wPatientTxt.width: 520
*wPatientTxt.isCompound: "true"
*wPatientTxt.compoundIcon: "textfield.xpm"
*wPatientTxt.compoundName: "text_Field"
*wPatientTxt.x: 180
*wPatientTxt.y: 180
*wPatientTxt.height: 40
*wPatientTxt.leftAttachment: "attach_widget"
*wPatientTxt.leftOffset: 15
*wPatientTxt.leftWidget: "label1"
*wPatientTxt.topAttachment: "attach_opposite_widget"
*wPatientTxt.topOffset: 0
*wPatientTxt.topWidget: "label1"

*wStudyTxt.class: textField
*wStudyTxt.static: true
*wStudyTxt.name: wStudyTxt
*wStudyTxt.parent: form1
*wStudyTxt.width: 520
*wStudyTxt.isCompound: "true"
*wStudyTxt.compoundIcon: "textfield.xpm"
*wStudyTxt.compoundName: "text_Field"
*wStudyTxt.x: 180
*wStudyTxt.y: 220
*wStudyTxt.height: 40
*wStudyTxt.leftAttachment: "attach_widget"
*wStudyTxt.leftOffset: 15
*wStudyTxt.leftWidget: "label1"
*wStudyTxt.topAttachment: "attach_opposite_widget"
*wStudyTxt.topOffset: 0
*wStudyTxt.topWidget: "label2"

*wSeriesTxt.class: textField
*wSeriesTxt.static: true
*wSeriesTxt.name: wSeriesTxt
*wSeriesTxt.parent: form1
*wSeriesTxt.width: 520
*wSeriesTxt.isCompound: "true"
*wSeriesTxt.compoundIcon: "textfield.xpm"
*wSeriesTxt.compoundName: "text_Field"
*wSeriesTxt.x: 180
*wSeriesTxt.y: 260
*wSeriesTxt.height: 40
*wSeriesTxt.leftAttachment: "attach_widget"
*wSeriesTxt.leftOffset: 15
*wSeriesTxt.leftWidget: "label1"
*wSeriesTxt.topAttachment: "attach_opposite_widget"
*wSeriesTxt.topOffset: 0
*wSeriesTxt.topWidget: "label3"

*wImageTxt.class: textField
*wImageTxt.static: true
*wImageTxt.name: wImageTxt
*wImageTxt.parent: form1
*wImageTxt.width: 520
*wImageTxt.isCompound: "true"
*wImageTxt.compoundIcon: "textfield.xpm"
*wImageTxt.compoundName: "text_Field"
*wImageTxt.x: 180
*wImageTxt.y: 300
*wImageTxt.height: 40
*wImageTxt.leftAttachment: "attach_widget"
*wImageTxt.leftOffset: 15
*wImageTxt.leftWidget: "label1"
*wImageTxt.topAttachment: "attach_opposite_widget"
*wImageTxt.topOffset: 0
*wImageTxt.topWidget: "label4"

*label5.class: label
*label5.static: true
*label5.name: label5
*label5.parent: form1
*label5.isCompound: "true"
*label5.compoundIcon: "label.xpm"
*label5.compoundName: "label_"
*label5.x: 40
*label5.y: 360
*label5.width: 110
*label5.height: 30
*label5.labelString: "Instance"
*label5.leftAttachment: "attach_opposite_widget"
*label5.leftOffset: 0
*label5.leftWidget: "label1"
*label5.topAttachment: "attach_widget"
*label5.topOffset: 15
*label5.topWidget: "label4"

*wInstanceTxt.class: textField
*wInstanceTxt.static: true
*wInstanceTxt.name: wInstanceTxt
*wInstanceTxt.parent: form1
*wInstanceTxt.width: 520
*wInstanceTxt.isCompound: "true"
*wInstanceTxt.compoundIcon: "textfield.xpm"
*wInstanceTxt.compoundName: "text_Field"
*wInstanceTxt.x: 150
*wInstanceTxt.y: 360
*wInstanceTxt.height: 40
*wInstanceTxt.leftAttachment: "attach_widget"
*wInstanceTxt.leftOffset: 15
*wInstanceTxt.leftWidget: "label1"
*wInstanceTxt.topAttachment: "attach_opposite_widget"
*wInstanceTxt.topOffset: 0
*wInstanceTxt.topWidget: "label5"

