/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* dialog.h */

#ifndef __DIALOG_H__

#define __DIALOG_H__

#include <gtk/gtk.h>
#include "typedefs.h"

/* Constant definitions */
typedef enum EnumAppErrorNum {
  APP_ERROR_NONE         = 0,
  FILE_NOT_EXISTS           ,
  PERMISSION_DENIED         ,
  FILE_ALREADY_EXISTS       ,
  NO_SPACE_LEFT             ,
  READ_ONLY_FS              ,
  TOO_LONG_FILE_NAME        ,
  RENAME_ERROR              ,
  REMOVE_ERROR              ,
  CHANGE_DIRECTORY_ERROR    ,
  OPEN_FILE_ERROR           ,
  PASTE_ERROR               ,
  FILE_READ_ERROR           ,
  FILE_WRITE_ERROR          ,
  DIRECTORY_ALREADY_EXISTS  ,
  DIRECTORY_NOT_EXISTS      ,
  MKDIR_ERROR               ,
  DIRECTORY_NOT_EMPTY       ,
  RMDIR_ERROR               ,
  INTERNAL_ERROR            ,
  ROTATION_ERROR
} AppErrorNum;

typedef enum EnumAppMessageNum {
  FILE_REMOVED         ,
  FILE_OVERWRITTEN     ,
  DIRECTORY_REMOVED    ,
  COPY_INSTEAD 
} AppMessageNum;

typedef enum EnumAppDialogType {
  APP_OK_ONLY_DIALOG            ,
  APP_CANCEL_ONLY_DIALOG        ,
  APP_OK_CANCEL_DIALOG          ,
  APP_OK_CANCEL_ALL_DIALOG      ,
  APP_OK_CANCEL_SKIP_ALL_DIALOG
} AppDialogType;

typedef enum EnumAppDialogDefaultButton {
  APP_OK_BUTTON     ,
  APP_CANCEL_BUTTON ,
  APP_SKIP_BUTTON   ,
  APP_ALL_BUTTON
} AppDialogDefaultButton;

/* Structure definitions */

/* Public function declarations. */
AppDialogResult dialog_message_dialog_create      (AppMessageNum         ,
                                                   gchar*                ,
                                                   AppDialogType         ,
                                                   AppDialogDefaultButton,
                                                   GtkWindow*              );

AppDialogResult dialog_error_dialog_create        (AppErrorNum           ,
                                                   gchar*                ,
                                                   GtkWindow*              );

void     dialog_progressbar_dialog_create         (gchar**               , 
                                                   ProgressbarDialog*      );

void     dialog_progressbar_dialog_update         (ProgressbarDialog*    ,
                                                   gint                  ,
                                                   gint                    );

void     dialog_progressbar_dialog_destroy        (ProgressbarDialog*      );


#endif  /* __DIALOG_H__ */

