/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class StringFn
extends SystemFunction {
    public Expression simplify() throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments();
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        super.analyze(staticContext);
        if (this.argument[0].getItemType() == Type.STRING_TYPE && this.argument[0].getCardinality() == 512) {
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(item.getStringValue());
    }
}

