/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private int requiredType;
    private Configuration config;

    public ContentTypeTest(int n, SchemaType schemaType, Configuration configuration) {
        this.kind = n;
        this.requiredType = schemaType.getFingerprint();
        this.config = configuration;
        this.originalText = schemaType.getDescription();
    }

    public ItemType getSuperType() {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int n, int n2, int n3) {
        if (this.kind != n) {
            return false;
        }
        if (n3 == this.requiredType) {
            return true;
        }
        if (n3 == -1) {
            return false;
        }
        SchemaType schemaType = this.config.getSchemaType(n3).getBaseType();
        while (schemaType != null) {
            if (schemaType.getFingerprint() == this.requiredType) {
                return true;
            }
            schemaType = schemaType.getBaseType();
        }
        return false;
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean allowsTextNodes() {
        return false;
    }

    public AtomicType getAtomizedItemType() {
        SimpleType simpleType;
        SchemaType schemaType = this.config.getSchemaType(this.requiredType);
        if (schemaType instanceof AtomicType) {
            return (AtomicType)schemaType;
        }
        if (schemaType instanceof ListType && (simpleType = ((ListType)schemaType).getItemType()) instanceof AtomicType) {
            return (AtomicType)simpleType;
        }
        return Type.ANY_ATOMIC_TYPE;
    }

    public String toString() {
        return this.originalText;
    }
}

