/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.DeferredError;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.Procedure;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected BigDecimal version = null;
    protected StaticContext staticContext = null;
    protected TransformerConfigurationException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    private int lineNumber;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public NamePool getTargetNamePool() {
        return this.getPrincipalStyleSheet().getTargetNamePool();
    }

    protected Configuration getConfiguration() {
        return this.getPreparedStyleSheet().getConfiguration();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void substituteFor(StyleElement styleElement) {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.nameCode = styleElement.nameCode;
        this.sequence = styleElement.sequence;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.root = styleElement.root;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
        this.lineNumber = styleElement.lineNumber;
    }

    protected void setValidationError(TransformerException transformerException, int n) {
        this.validationError = transformerException instanceof TransformerConfigurationException ? (TransformerConfigurationException)transformerException : new TransformerConfigurationException(transformerException);
        this.reportingCircumstances = n;
    }

    public boolean isInstruction() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        NodeInfo nodeInfo;
        ItemType itemType = NoNodeTest.getInstance();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return itemType;
        } while ((itemType = nodeInfo instanceof StyleElement ? Type.getCommonSuperType(itemType, ((StyleElement)nodeInfo).getReturnedItemType()) : Type.getCommonSuperType(itemType, NodeKindTest.TEXT)) != AnyItemType.getInstance());
        return itemType;
    }

    public void markTailCalls() {
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    public XSLStyleSheet getContainingStyleSheet() {
        NodeInfo nodeInfo = this;
        while (!(nodeInfo instanceof XSLStyleSheet)) {
            nodeInfo = nodeInfo.getParent();
        }
        return (XSLStyleSheet)nodeInfo;
    }

    public int getPrecedence() {
        return this.getContainingStyleSheet().getPrecedence();
    }

    public String getURIForPrefix(String string, boolean bl) throws NamespaceException {
        if (string.equals("") && !bl) {
            return "";
        }
        short s = this.getURICodeForPrefix(string);
        return this.getNamePool().getURIFromURICode(s);
    }

    public final int makeNameCode(String string) throws XPathException, NamespaceException {
        String[] stringArray;
        NamePool namePool = this.getTargetNamePool();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            return namePool.allocate(string2, (short)0, string);
        }
        String string3 = this.getURIForPrefix(string2, false);
        if (NamespaceConstant.isReserved(string3)) {
            throw new XPathException.Static("Namespace prefix " + string2 + " refers to a reserved namespace");
        }
        return namePool.allocate(string2, string3, stringArray[1]);
    }

    public NamespaceContext makeNamespaceContext() {
        int[] nArray = this.getNamespaceCodes();
        int[] nArray2 = new int[nArray.length];
        NamePool namePool = this.getNamePool();
        NamePool namePool2 = this.getTargetNamePool();
        int n = 0;
        while (n < nArray.length) {
            String string = namePool.getPrefixFromNamespaceCode(nArray[n]);
            String string2 = namePool.getURIFromNamespaceCode(nArray[n]);
            nArray2[n] = namePool2.allocateNamespaceCode(string, string2);
            ++n;
        }
        return new NamespaceContext(nArray2, namePool2);
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).processAllAttributes();
        }
        return;
    }

    public String getAttributeValue(String string) {
        int n = this.getNamePool().allocateClarkName(string);
        return this.getAttributeValue(n);
    }

    public final void processAttributes() throws TransformerConfigurationException {
        block3: {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if (this.forwardsCompatibleModeIsEnabled()) {
                    this.setValidationError(transformerConfigurationException, 3);
                    break block3;
                }
                this.compileError(transformerConfigurationException);
            }
        }
    }

    protected void checkUnknownAttribute(int n) throws TransformerConfigurationException {
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        String string = this.getNamePool().getURI(n);
        String string2 = this.getURI();
        String string3 = this.getNamePool().getClarkName(n);
        if (this.isInstruction() && string3.startsWith("{http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.endsWith("}xpath-default-namespace") || string3.endsWith("}extension-element-prefixes") || string3.endsWith("}exclude-result-prefixes") || string3.endsWith("}version"))) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3 == "xpath-default-namespace" || string3 == "extension-element-prefixes" || string3 == "exclude-result-prefixes" || string3 == "version")) {
            return;
        }
        if (string.equals("") || string.equals("http://www.w3.org/1999/XSL/Transform")) {
            this.compileError("Attribute {" + this.getNamePool().getDisplayName(n) + "} is not allowed on this element");
        }
    }

    public abstract void prepareAttributes() throws TransformerConfigurationException;

    protected StyleElement getLastChildInstruction() {
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            styleElement = null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string) throws TransformerConfigurationException {
        try {
            return ExpressionTool.make(string, this.staticContext, 0, 0);
        }
        catch (XPathException xPathException) {
            if (!this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(xPathException);
            }
            return new ErrorExpression(xPathException);
        }
    }

    public Pattern makePattern(String string) throws TransformerConfigurationException {
        try {
            return Pattern.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return NoNodeTest.getInstance();
        }
    }

    public Expression makeAttributeValueTemplate(String string) throws TransformerConfigurationException {
        try {
            return AttributeValueTemplate.make(string + '\u0000', 0, '\u0000', this.staticContext, null, false);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringValue(string);
        }
    }

    public SequenceType makeSequenceType(String string) throws TransformerConfigurationException {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        try {
            ExpressionParser expressionParser = new ExpressionParser();
            return expressionParser.parseSequenceType(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            this.extensionNamespaces = new short[n];
            n = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if (string3.equals("#default")) {
                    string3 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string3);
                    this.extensionNamespaces[n++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.extensionNamespaces = null;
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
    }

    protected void processExcludedNamespaces(String string) throws TransformerConfigurationException {
        block10: {
            String string2 = this.getAttributeValue(string);
            if (string2 == null) break block10;
            if (string2.trim().equals("#all")) {
                int[] nArray = this.getNamespaceCodes();
                this.excludedNamespaces = new short[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    this.excludedNamespaces[n] = (short)(nArray[n] & 0xFFFF);
                    ++n;
                }
            } else {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                this.excludedNamespaces = new short[n];
                n = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if (string3.equals("#default")) {
                        string3 = "";
                    } else if (string3.equals("#all")) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values");
                    }
                    try {
                        short s = this.getURICodeForPrefix(string3);
                        this.excludedNamespaces[n++] = s;
                    }
                    catch (NamespaceException namespaceException) {
                        this.excludedNamespaces = null;
                        this.compileError(namespaceException.getMessage());
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            try {
                this.version = new DecimalValue(string2).getValue();
            }
            catch (XPathException xPathException) {
                throw new TransformerConfigurationException("The version attribute must be a decimal literal");
            }
        }
    }

    public BigDecimal getVersion() {
        if (this.version == null) {
            NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
            this.version = nodeInfo instanceof StyleElement ? ((StyleElement)nodeInfo).getVersion() : new BigDecimal("2.0");
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) > 0;
    }

    public boolean backwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) < 0;
    }

    protected boolean definesExtensionElement(short s) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.extensionNamespaces.length) {
            if (this.extensionNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExtensionNamespace(short s) {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short s) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.excludedNamespaces.length) {
            if (this.excludedNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExcludedNamespace(short s) {
        if (s == 2) {
            return true;
        }
        if (this.isExtensionNamespace(s)) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            this.defaultXPathNamespace = string2;
        }
    }

    protected short getDefaultXPathNamespace() {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            String string = nodeInfo.defaultXPathNamespace;
            if (string != null) {
                return this.getTargetNamePool().allocateCodeForURI(string);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return 0;
    }

    public SchemaType getSchemaType(String string) throws TransformerConfigurationException {
        try {
            String string2;
            int n;
            String[] stringArray = Name.getQNameParts(string);
            String string3 = stringArray[1];
            if (stringArray[0].equals("")) {
                n = this.getDefaultXPathNamespace();
                string2 = this.getTargetNamePool().getURIFromURICode((short)n);
                this.nameCode = this.getTargetNamePool().allocate(stringArray[0], (short)n, string3);
            } else {
                string2 = this.getURIForPrefix(stringArray[0], false);
            }
            n = this.getTargetNamePool().allocate(stringArray[0], string2, string3);
            if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(StandardNames.getFingerprint(string2, string3));
                if (schemaType == null) {
                    this.compileError("Unknown built-in type " + string);
                    return null;
                }
                schemaType.setFingerprint(n & 0xFFFFF);
                return schemaType;
            }
            if (string2.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
                ItemType itemType = Type.getBuiltInItemType(string2, string3);
                if (itemType == null) {
                    if (string3.equals("untyped")) {
                        this.compileError("Cannot validate a node as 'untyped'");
                    } else {
                        this.compileError("Unknown built-in type " + string);
                    }
                }
                ((SimpleType)((Object)itemType)).setFingerprint(n & 0xFFFFF);
                return (SimpleType)((Object)itemType);
            }
            if (!this.getPrincipalStyleSheet().isImportedSchema(string2)) {
                this.compileError("There is no imported schema for the namespace of type " + string);
                return null;
            }
            SchemaType schemaType = this.getConfiguration().getSchemaType(n & 0xFFFFF);
            if (schemaType == null) {
                this.compileError("There is no type named " + string + " in an imported schema");
            }
            return schemaType;
        }
        catch (NamespaceException namespaceException) {
            this.compileError("Namespace prefix for type annotation is undeclared");
        }
        catch (QNameException qNameException) {
            this.compileError("Invalid type name. " + qNameException.getMessage());
        }
        return null;
    }

    public int getTypeAnnotation(SchemaType schemaType) {
        if (schemaType != null) {
            return schemaType.getFingerprint();
        }
        return -1;
    }

    public void validate() throws TransformerConfigurationException {
    }

    public void postValidate() throws TransformerConfigurationException {
    }

    public Expression typeCheck(String string, Expression expression) throws TransformerConfigurationException {
        if (expression == null) {
            return null;
        }
        try {
            expression = expression.analyze(this.staticContext);
            if (this.isExplaining()) {
                System.err.println("Attribute '" + string + "' of element '" + this.getDisplayName() + "' at line " + this.getLineNumber() + ":");
                System.err.println("Static type: " + new SequenceType(expression.getItemType(), expression.getCardinality()));
                System.err.println("Optimized expression tree:");
                expression.display(10, this.getNamePool());
            }
            this.allocateSlots(expression);
            return expression;
        }
        catch (XPathException.Dynamic dynamic) {
            return new ErrorExpression(dynamic);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return expression;
        }
    }

    public void allocateSlots(Expression expression) {
        Procedure procedure = this.getOwningProcedure();
        if (procedure == null || this instanceof XSLTemplate) {
            int n = ExpressionTool.allocateSlots(expression, 0);
            this.getContainingStyleSheet().allocateLocalSlots(n);
        } else {
            int n = procedure.getNumberOfVariables();
            int n2 = ExpressionTool.allocateSlots(expression, n);
            if (n2 > n) {
                this.getContainingStyleSheet().allocateLocalSlots(n2);
                procedure.setNumberOfVariables(n2);
            }
        }
    }

    private boolean isExplaining() {
        String string = this.getAttributeValue("{http://saxon.sf.net/}explain");
        return "yes".equals(string);
    }

    public Pattern typeCheck(String string, Pattern pattern) throws TransformerConfigurationException {
        if (pattern == null) {
            return null;
        }
        try {
            return pattern.typeCheck(this.staticContext);
        }
        catch (XPathException.Dynamic dynamic) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter(new ErrorExpression(dynamic));
            return locationPathPattern;
        }
        catch (XPathException xPathException) {
            throw new TransformerConfigurationException("Error in " + string + " pattern", xPathException);
        }
    }

    public void fixupReferences() throws TransformerConfigurationException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).fixupReferences();
        }
        return;
    }

    public Procedure getOwningProcedure() {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = nodeInfo.getParent()) instanceof XSLStyleSheet) {
                if (nodeInfo instanceof XSLTemplate) {
                    return ((XSLTemplate)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLGeneralVariable) {
                    return ((XSLGeneralVariable)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLFunction) {
                    return ((XSLFunction)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLAttributeSet) {
                    return ((XSLAttributeSet)nodeInfo).getProcedure();
                }
                return null;
            }
            nodeInfo = nodeInfo2;
        }
    }

    public void validateSubtree() throws TransformerConfigurationException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        }
        try {
            this.validate();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(transformerConfigurationException, 3);
            }
            this.compileError(transformerConfigurationException);
        }
        this.validateChildren();
        this.postValidate();
    }

    protected void validateChildren() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).validateSubtree();
            styleElement = (StyleElement)nodeInfo;
        }
        if (styleElement instanceof XSLVariable && !(this instanceof XSLStyleSheet)) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect");
        }
    }

    protected XSLStyleSheet getPrincipalStyleSheet() {
        XSLStyleSheet xSLStyleSheet = this.getContainingStyleSheet();
        XSLStyleSheet xSLStyleSheet2;
        while ((xSLStyleSheet2 = xSLStyleSheet.getImporter()) != null) {
            xSLStyleSheet = xSLStyleSheet2;
        }
        return xSLStyleSheet;
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        return this.getPrincipalStyleSheet().getPreparedStyleSheet();
    }

    public void checkWithinTemplate() throws TransformerConfigurationException {
        StyleElement styleElement = (StyleElement)this.getParentNode();
        if (!styleElement.mayContainSequenceConstructor()) {
            this.compileError("Element must only be used within a sequence constructor");
        }
    }

    public void checkTopLevel() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLStyleSheet)) {
            this.compileError("Element must only be used at top level of stylesheet");
        }
    }

    public void checkEmpty() throws TransformerConfigurationException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty");
        }
    }

    public void reportAbsence(String string) throws TransformerConfigurationException {
        this.compileError("Element must have a \"" + string + "\" attribute");
    }

    public ItemType getContextItemType() {
        if (this.isTopLevel()) {
            return NodeKindTest.DOCUMENT;
        }
        return ((StyleElement)this.getParent()).getContextItemType();
    }

    public abstract Instruction compile(Executable var1) throws TransformerConfigurationException;

    public Instruction[] compileChildren(Executable executable, Instruction instruction) throws TransformerConfigurationException {
        Instr[] instrArray;
        instruction.setExecutable(executable);
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        ArrayList<SourceLocator> arrayList = new ArrayList<SourceLocator>();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((instrArray = (Instr[])axisIterator.next()) != null) {
            SourceLocator sourceLocator;
            if (instrArray.getNodeKind() == 3) {
                sourceLocator = new Text(false);
                ((Instruction)sourceLocator).setExecutable(executable);
                ((SimpleNodeConstructor)sourceLocator).setSelect(new StringValue(instrArray.getStringValue()));
                ((Instruction)sourceLocator).setSourceLocation(xSLStyleSheet.putModuleNumber(instrArray.getSystemId()), instrArray.getLineNumber());
                arrayList.add(sourceLocator);
                continue;
            }
            if (!(instrArray instanceof StyleElement)) continue;
            sourceLocator = (StyleElement)instrArray;
            if (((StyleElement)sourceLocator).validationError != null) {
                this.fallbackProcessing(executable, (StyleElement)sourceLocator, arrayList);
                continue;
            }
            Instruction instruction2 = ((StyleElement)sourceLocator).compile(executable);
            if (instruction2 == null) continue;
            instruction2.setExecutable(executable);
            instruction2.setSourceLocation(xSLStyleSheet.putModuleNumber(((ElementImpl)sourceLocator).getSystemId()), ((StyleElement)sourceLocator).getLineNumber());
            if (this.getConfiguration().getTraceListener() != null) {
                instruction2 = super.makeTraceInstruction(instruction2);
                instruction2.setExecutable(executable);
            }
            arrayList.add(instruction2);
        }
        instrArray = new Instruction[arrayList.size()];
        instrArray = arrayList.toArray(instrArray);
        instruction.setChildren(instrArray);
        return instrArray;
    }

    private TraceInstruction makeTraceInstruction(Instruction instruction) {
        if (instruction instanceof TraceInstruction) {
            return (TraceInstruction)instruction;
        }
        TraceInstruction traceInstruction = new TraceInstruction(instruction);
        this.setAdditionalTraceProperties(traceInstruction);
        return traceInstruction;
    }

    protected void setAdditionalTraceProperties(TraceInstruction traceInstruction) {
    }

    protected void fallbackProcessing(Executable executable, StyleElement styleElement, List list) throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        boolean bl = false;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLFallback)) continue;
            bl = true;
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            Block block = new Block();
            block.setSourceLocation(xSLStyleSheet.putModuleNumber(nodeInfo.getSystemId()), nodeInfo.getLineNumber());
            block.setInstructionName((byte)2);
            ((XSLFallback)nodeInfo).compileChildren(executable, block);
            list.add(block);
        }
        if (!bl) {
            list.add(new DeferredError(styleElement.validationError, styleElement.getDisplayName()));
        }
    }

    protected SortKeyDefinition[] makeSortKeys() {
        SortKeyDefinition[] sortKeyDefinitionArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((sortKeyDefinitionArray = axisIterator.next()) != null) {
            if (!(sortKeyDefinitionArray instanceof XSLSort)) continue;
            ++n;
        }
        if (n > 0) {
            NodeInfo nodeInfo;
            sortKeyDefinitionArray = new SortKeyDefinition[n];
            axisIterator = this.iterateAxis((byte)3);
            int n2 = 0;
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLSort)) continue;
                sortKeyDefinitionArray[n2++] = ((XSLSort)nodeInfo).getSortKeyDefinition();
            }
            return sortKeyDefinitionArray;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String string, List arrayList) throws TransformerConfigurationException {
        int n;
        AttributeSet[] attributeSetArray;
        if (arrayList == null) {
            arrayList = new ArrayList<XSLAttributeSet>();
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            attributeSetArray = stringTokenizer.nextToken();
            try {
                n = this.makeNameCode((String)attributeSetArray) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
                n = -1;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
                n = -1;
            }
            boolean bl = false;
            int n2 = 0;
            while (n2 < list.size()) {
                XSLAttributeSet xSLAttributeSet;
                if (list.get(n2) instanceof XSLAttributeSet && (xSLAttributeSet = (XSLAttributeSet)list.get(n2)).getAttributeSetFingerprint() == n) {
                    arrayList.add(xSLAttributeSet);
                    bl = true;
                }
                ++n2;
            }
            if (bl) continue;
            this.compileError("No attribute-set exists named " + (String)attributeSetArray);
        }
        attributeSetArray = new AttributeSet[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)arrayList.get(n);
            xSLAttributeSet.incrementReferenceCount();
            attributeSetArray[n] = xSLAttributeSet.getInstruction();
            ++n;
        }
        return attributeSetArray;
    }

    protected WithParam[] getWithParamInstructions(Executable executable, boolean bl) throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        WithParam[] withParamArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((withParamArray = (WithParam[])axisIterator.next()) != null) {
            if (!(withParamArray instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo = (XSLWithParam)withParamArray)).isTunnelParam() != bl) continue;
            ++n;
        }
        withParamArray = new WithParam[n];
        n = 0;
        axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            NodeInfo nodeInfo2;
            if (!(nodeInfo instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo2 = nodeInfo)).isTunnelParam() != bl) continue;
            withParamArray[n++] = (WithParam)((XSLWithParam)nodeInfo2).compile(executable);
        }
        return withParamArray;
    }

    protected void compileError(TransformerException transformerException) throws TransformerConfigurationException {
        if (transformerException.getLocator() == null || transformerException.getLocator() instanceof ExpressionLocation) {
            transformerException.setLocator(this);
        }
        PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
        try {
            if (preparedStyleSheet == null) {
                throw transformerException;
            }
            preparedStyleSheet.reportError(transformerException);
        }
        catch (TransformerException transformerException2) {
            if (transformerException2 instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2;
            }
            if (transformerException2.getException() instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2.getException();
            }
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(transformerException);
            transformerConfigurationException.setLocator(this);
            throw transformerConfigurationException;
        }
    }

    protected void compileError(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.compileError(transformerConfigurationException);
    }

    protected void compileWarning(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
        if (preparedStyleSheet != null) {
            preparedStyleSheet.reportWarning(transformerConfigurationException);
        }
    }

    protected void issueWarning(TransformerException transformerException) {
        PreparedStyleSheet preparedStyleSheet;
        if (transformerException.getLocator() == null) {
            transformerException.setLocator(this);
        }
        if ((preparedStyleSheet = this.getPreparedStyleSheet()) != null) {
            preparedStyleSheet.reportWarning(transformerException);
        }
    }

    protected void issueWarning(String string) {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.issueWarning(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public XSLVariableDeclaration bindVariable(int n) throws XPathException.Static {
        XSLVariableDeclaration xSLVariableDeclaration = this.getVariableBinding(n);
        if (xSLVariableDeclaration == null) {
            throw new XPathException.Static("Variable " + this.getTargetNamePool().getDisplayName(n) + " has not been declared");
        }
        return xSLVariableDeclaration;
    }

    public XSLVariableDeclaration getVariableBinding(int n) {
        XSLVariableDeclaration xSLVariableDeclaration;
        Object object;
        block3: {
            NodeInfo nodeInfo = this;
            NodeInfo nodeInfo2 = this;
            if (!this.isTopLevel()) {
                object = nodeInfo.iterateAxis((byte)11);
                do {
                    nodeInfo = (NodeInfo)object.next();
                    while (nodeInfo == null) {
                        nodeInfo = nodeInfo2.getParent();
                        nodeInfo2 = nodeInfo;
                        if (nodeInfo.getParent() instanceof XSLStyleSheet) break;
                        object = nodeInfo.iterateAxis((byte)11);
                        nodeInfo = (NodeInfo)object.next();
                    }
                    if (nodeInfo.getParent() instanceof XSLStyleSheet) break block3;
                } while (!(nodeInfo instanceof XSLVariableDeclaration) || (xSLVariableDeclaration = (XSLVariableDeclaration)nodeInfo).getVariableFingerprint() != n);
                return xSLVariableDeclaration;
            }
        }
        object = this.getPrincipalStyleSheet();
        xSLVariableDeclaration = ((XSLStyleSheet)object).getGlobalVariable(n);
        return xSLVariableDeclaration;
    }

    public XSLFunction getStyleSheetFunction(int n, int n2) {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            Object e = list.get(n3);
            if (e instanceof XSLFunction && ((XSLFunction)e).getFunctionFingerprint() == n && (n2 == -1 || ((XSLFunction)e).getNumberOfArguments() == n2)) {
                XSLFunction xSLFunction = (XSLFunction)e;
                return xSLFunction;
            }
            --n3;
        }
        return null;
    }
}

