/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.CallTemplate;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLCallTemplate
extends StyleElement {
    private int calledTemplateFingerprint = -1;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private String calledTemplateName = null;
    private Expression calledTemplateExpression;

    protected boolean allowAVT() {
        return false;
    }

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.template == null) {
            return AnyItemType.getInstance();
        }
        return this.template.getReturnedItemType();
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "name") {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (this.allowAVT() && string.indexOf(123) >= 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(string);
        } else {
            this.calledTemplateName = string;
            try {
                this.calledTemplateFingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.calledTemplateExpression == null) {
            this.template = this.findTemplate(this.calledTemplateFingerprint);
            if (this.template == null) {
                return;
            }
        }
        this.calledTemplateExpression = this.typeCheck("name", this.calledTemplateExpression);
    }

    public void postValidate() throws TransformerConfigurationException {
        if (this.template != null) {
            Object object;
            Object object2;
            Object object3;
            AxisIterator axisIterator = this.template.iterateAxis((byte)3);
            while ((object3 = (NodeInfo)axisIterator.next()) != null) {
                if (!(object3 instanceof XSLParam) || !((XSLParam)object3).isRequiredParam() || ((XSLParam)object3).isTunnelParam()) continue;
                object2 = this.iterateAxis((byte)3);
                boolean bl = false;
                while ((object = (NodeInfo)object2.next()) != null) {
                    if (!(object instanceof XSLWithParam) || ((XSLWithParam)object).getVariableFingerprint() != ((XSLParam)object3).getVariableFingerprint()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.compileError("No value supplied for required parameter " + ((XSLParam)object3).getVariableName());
            }
            object3 = this.iterateAxis((byte)3);
            while ((object2 = (NodeInfo)object3.next()) != null) {
                NodeInfo nodeInfo;
                if (!(object2 instanceof XSLWithParam) || ((XSLWithParam)object2).isTunnelParam()) continue;
                XSLWithParam xSLWithParam = (XSLWithParam)object2;
                object = this.template.iterateAxis((byte)3);
                boolean bl = false;
                while ((nodeInfo = (NodeInfo)object.next()) != null) {
                    if (!(nodeInfo instanceof XSLParam) || ((XSLParam)nodeInfo).getVariableFingerprint() != xSLWithParam.getVariableFingerprint()) continue;
                    bl = true;
                    SequenceType sequenceType = ((XSLParam)nodeInfo).getRequiredType();
                    xSLWithParam.checkAgainstRequiredType(sequenceType);
                    break;
                }
                if (bl) continue;
                this.compileError("Parameter " + xSLWithParam.getVariableName() + " is not declared in the called template");
            }
        }
    }

    private XSLTemplate findTemplate(int n) throws TransformerConfigurationException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            XSLTemplate xSLTemplate;
            if (list.get(n2) instanceof XSLTemplate && (xSLTemplate = (XSLTemplate)list.get(n2)).getTemplateFingerprint() == n) {
                return xSLTemplate;
            }
            --n2;
        }
        this.compileError("No template exists named " + this.calledTemplateName);
        return null;
    }

    public void markTailCalls() {
        this.useTailRecursion = true;
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        Template template = null;
        NamespaceContext namespaceContext = null;
        if (this.calledTemplateExpression == null) {
            if (this.template == null) {
                return null;
            }
            template = this.template.getCompiledTemplate();
        } else {
            namespaceContext = this.makeNamespaceContext();
        }
        return new CallTemplate(template, this.getWithParamInstructions(executable, false), this.getWithParamInstructions(executable, true), this.useTailRecursion, this.calledTemplateExpression, namespaceContext);
    }

    protected void setAdditionalTraceProperties(TraceInstruction traceInstruction) {
        if (this.template != null) {
            traceInstruction.setProperty("name", this.template.getAttributeValue("name"));
        }
    }
}

