/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLOutput
extends StyleElement {
    private int fingerprint = -1;
    private String method = null;
    private String version = null;
    private String indent = null;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private String omitDeclaration = null;
    private String standalone = null;
    private String cdataElements = null;
    private String includeContentType = null;
    private String nextInChain = null;
    private String representation = null;
    private String indentSpaces = null;
    private String byteOrderMark = null;
    private String escapeURIAttributes = null;
    private String requireWellFormed = null;
    private String undeclareNamespaces = null;
    private String useCharacterMaps = null;
    private HashMap userAttributes = null;

    public void prepareAttributes() throws TransformerConfigurationException {
        block47: {
            AttributeCollection attributeCollection = this.getAttributeList();
            String string = null;
            int n = 0;
            while (n < attributeCollection.getLength()) {
                int n2 = attributeCollection.getNameCode(n);
                String string2 = this.getNamePool().getClarkName(n2);
                if (string2 == "name") {
                    string = attributeCollection.getValue(n).trim();
                } else if (string2 == "method") {
                    this.method = attributeCollection.getValue(n).trim();
                } else if (string2 == "version") {
                    this.version = attributeCollection.getValue(n).trim();
                } else if (string2 == "encoding") {
                    this.encoding = attributeCollection.getValue(n).trim();
                } else if (string2 == "omit-xml-declaration") {
                    this.omitDeclaration = attributeCollection.getValue(n).trim();
                } else if (string2 == "standalone") {
                    this.standalone = attributeCollection.getValue(n).trim();
                } else if (string2 == "doctype-public") {
                    this.doctypePublic = attributeCollection.getValue(n).trim();
                } else if (string2 == "doctype-system") {
                    this.doctypeSystem = attributeCollection.getValue(n).trim();
                } else if (string2 == "cdata-section-elements") {
                    this.cdataElements = attributeCollection.getValue(n);
                } else if (string2 == "indent") {
                    this.indent = attributeCollection.getValue(n).trim();
                } else if (string2 == "media-type") {
                    this.mediaType = attributeCollection.getValue(n).trim();
                } else if (string2 == "include-content-type") {
                    this.includeContentType = attributeCollection.getValue(n).trim();
                } else if (string2 == "escape-uri-attributes") {
                    this.escapeURIAttributes = attributeCollection.getValue(n).trim();
                } else if (string2 == "use-character-maps") {
                    this.useCharacterMaps = attributeCollection.getValue(n);
                } else if (string2 == "undeclare-namespaces") {
                    this.undeclareNamespaces = attributeCollection.getValue(n);
                } else if (string2 == "{http://saxon.sf.net/}character-representation") {
                    this.representation = attributeCollection.getValue(n).trim();
                } else if (string2 == "{http://saxon.sf.net/}indent-spaces") {
                    this.indentSpaces = attributeCollection.getValue(n).trim();
                } else if (string2 == "{http://saxon.sf.net/}next-in-chain") {
                    this.nextInChain = attributeCollection.getValue(n).trim();
                } else if (string2 == "{http://saxon.sf.net/}byte-order-mark") {
                    this.byteOrderMark = attributeCollection.getValue(n).trim();
                } else if (string2 == "{http://saxon.sf.net/}require-well-formed") {
                    this.requireWellFormed = attributeCollection.getValue(n).trim();
                } else {
                    String string3 = this.getNamePool().getURI(n2);
                    if ("".equals(string3) || "http://www.w3.org/1999/XSL/Transform".equals(string3) || "http://saxon.sf.net/".equals(string3)) {
                        this.checkUnknownAttribute(n2);
                    } else {
                        String string4 = "{" + string3 + "}" + attributeCollection.getLocalName(n);
                        if (this.userAttributes == null) {
                            this.userAttributes = new HashMap(5);
                        }
                        this.userAttributes.put(string4, attributeCollection.getValue(n));
                    }
                }
                ++n;
            }
            if (string == null) break block47;
            try {
                this.fingerprint = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
    }

    public int getOutputFingerprint() {
        return this.fingerprint;
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public Instruction compile(Executable executable) {
        return null;
    }

    protected Properties gatherOutputProperties(Properties properties) throws TransformerConfigurationException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        if (this.method != null) {
            if (this.method.equals("xml") || this.method.equals("html") || this.method.equals("text") || this.method.equals("xhtml")) {
                properties.put("method", this.method);
            } else {
                object4 = null;
                try {
                    object4 = Name.getQNameParts(this.method);
                    string = object4[0];
                    if (string.equals("")) {
                        this.compileError("method must be xml, html, xhtml, or text, or a prefixed name");
                    } else {
                        object3 = this.getURIForPrefix(string, false);
                        properties.put("method", "{" + (String)object3 + "}" + object4[1]);
                    }
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid method name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
        if (this.version != null) {
            properties.put("version", this.version);
        }
        if (this.indent != null) {
            if (this.indent.equals("yes") || this.indent.equals("no")) {
                properties.put("indent", this.indent);
            } else {
                this.compileError("indent must be yes or no");
            }
        }
        if (this.indentSpaces != null) {
            try {
                Integer.parseInt(this.indentSpaces);
                properties.put("indent", "yes");
                properties.put("{http://saxon.sf.net/}indent-spaces", this.indentSpaces);
            }
            catch (NumberFormatException numberFormatException) {
                this.compileError("saxon:indent-spaces must be an integer");
            }
        }
        if (this.encoding != null) {
            properties.put("encoding", this.encoding);
        }
        if (this.mediaType != null) {
            properties.put("media-type", this.mediaType);
        }
        if (this.doctypeSystem != null) {
            properties.put("doctype-system", this.doctypeSystem);
        }
        if (this.doctypePublic != null) {
            properties.put("doctype-public", this.doctypePublic);
        }
        if (this.omitDeclaration != null) {
            if (this.omitDeclaration.equals("yes") || this.omitDeclaration.equals("no")) {
                properties.put("omit-xml-declaration", this.omitDeclaration);
            } else {
                this.compileError("omit-xml-declaration attribute must be yes or no");
            }
        }
        if (this.standalone != null) {
            if (this.standalone.equals("yes") || this.standalone.equals("no")) {
                properties.put("standalone", this.standalone);
            } else {
                this.compileError("standalone attribute must be yes or no");
            }
        }
        if (this.cdataElements != null) {
            object4 = properties.getProperty("cdata-section-elements");
            if (object4 == null) {
                object4 = "";
            }
            string = "";
            object3 = new StringTokenizer(this.cdataElements);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                try {
                    object = Name.getQNameParts((String)object2);
                    stringArray = this.getURIForPrefix(object[0], true);
                    string = string + " {" + (String)stringArray + '}' + object[1];
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid CDATA element name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                properties.put("cdata-section-elements", (String)object4 + string);
            }
        }
        if (this.undeclareNamespaces != null) {
            if (this.undeclareNamespaces.equals("yes") || this.undeclareNamespaces.equals("no")) {
                properties.put("{http://saxon.sf.net/}undeclare-namespaces", this.undeclareNamespaces);
            } else {
                this.compileError("undeclare-namespaces value must be yes or no");
            }
        }
        if (this.useCharacterMaps != null) {
            object4 = this.getPrincipalStyleSheet();
            string = properties.getProperty("{http://saxon.sf.net/}use-character-maps");
            if (string == null) {
                string = "";
            }
            object3 = "";
            object2 = new StringTokenizer(this.useCharacterMaps);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                try {
                    stringArray = Name.getQNameParts((String)object);
                    String string2 = this.getURIForPrefix(stringArray[0], false);
                    int n = this.getTargetNamePool().allocate(stringArray[0], string2, stringArray[1]);
                    XSLCharacterMap xSLCharacterMap = ((XSLStyleSheet)object4).getCharacterMap(n & 0xFFFFF);
                    if (xSLCharacterMap == null) {
                        this.compileError("No character-map named '" + (String)object + "' has been defined");
                    }
                    object3 = (String)object3 + " {" + string2 + '}' + stringArray[1];
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                properties.put("{http://saxon.sf.net/}use-character-maps", string + (String)object3);
            }
        }
        if (this.representation != null) {
            properties.put("{http://saxon.sf.net/}character-representation", this.representation);
        }
        if (this.includeContentType != null) {
            if (this.includeContentType.equals("yes") || this.includeContentType.equals("no")) {
                properties.put("{http://saxon.sf.net/}include-content-type", this.includeContentType);
            } else {
                this.compileError("include-content-type attribute must be yes or no");
            }
        }
        if (this.escapeURIAttributes != null) {
            if (this.escapeURIAttributes.equals("yes") || this.escapeURIAttributes.equals("no")) {
                properties.put("{http://saxon.sf.net/}escape-uri-attibutes", this.escapeURIAttributes);
            } else {
                this.compileError("escape-uri-attributes value must be yes or no");
            }
        }
        if (this.nextInChain != null) {
            properties.put("{http://saxon.sf.net/}next-in-chain", this.nextInChain);
            properties.put("{http://saxon.sf.net/}next-in-chain-base-uri", this.getSystemId());
        }
        if (this.byteOrderMark != null) {
            if (this.byteOrderMark.equals("yes") || this.byteOrderMark.equals("no")) {
                properties.put("{http://saxon.sf.net/}byte-order-mark", this.byteOrderMark);
            } else {
                this.compileError("saxon:byte-order-mark value must be yes or no");
            }
        }
        if (this.requireWellFormed != null) {
            if (this.requireWellFormed.equals("yes") || this.requireWellFormed.equals("no")) {
                properties.put("{http://saxon.sf.net/}require-well-formed", this.requireWellFormed);
            } else {
                this.compileError("saxon:require-well-formed value must be yes or no");
            }
        }
        if (this.userAttributes != null) {
            object4 = this.userAttributes.keySet().iterator();
            while (object4.hasNext()) {
                string = (String)object4.next();
                object3 = (String)this.userAttributes.get(string);
                properties.put(string, object3);
            }
        }
        return properties;
    }
}

