/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class SingletonNode
extends Value {
    protected NodeInfo node = null;

    public SingletonNode(NodeInfo nodeInfo) {
        this.node = nodeInfo;
    }

    public ItemType getItemType() {
        return AnyNodeTest.getInstance();
    }

    public int getCardinality() {
        if (this.node == null) {
            return 256;
        }
        return 512;
    }

    public NodeInfo getNode() {
        return this.node;
    }

    public int getSpecialProperties() {
        return 131072;
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return SingletonIterator.makeIterator(this.node);
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.node;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.node != null;
    }

    public String getStringValue() throws XPathException {
        return this.node == null ? "" : this.node.getStringValue();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        if (this.node == null) {
            return "";
        }
        return this.node.getStringValue();
    }

    public void display(int n, NamePool namePool) {
        if (this.node == null) {
            System.err.println(ExpressionTool.indent(n) + "Empty node-set");
        } else {
            System.err.println(ExpressionTool.indent(n) + "Node " + Navigator.getPath(this.node));
        }
    }

    public int conversionPreference(Class clazz, Configuration configuration) {
        return SequenceValue.nodeToJavaPreference(this.node, clazz, configuration);
    }

    public Object convertToJava(Class clazz, Configuration configuration) throws XPathException {
        return new SequenceExtent(this.iterate(null)).convertToJava(clazz, configuration);
    }
}

