/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.XPathParser;

class Lexer {
    private Compiler m_compiler;
    PrefixResolver m_namespaceContext;
    XPathParser m_processor;
    static final int TARGETEXTRA = 10000;
    private int[] m_patternMap = new int[100];
    private int m_patternMapSize;

    Lexer(Compiler compiler, PrefixResolver prefixResolver, XPathParser xPathParser) {
        this.m_compiler = compiler;
        this.m_namespaceContext = prefixResolver;
        this.m_processor = xPathParser;
    }

    private final void addToTokenQueue(String string) {
        this.m_compiler.m_tokenQueue[this.m_compiler.m_tokenQueueSize++] = string;
    }

    final int getKeywordToken(String string) {
        int n;
        try {
            Integer n2 = (Integer)Keywords.m_keywords.get(string);
            n = n2 != null ? n2 : 0;
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        catch (ClassCastException classCastException) {
            n = 0;
        }
        return n;
    }

    private int getTokenQueuePosFromMap(int n) {
        int n2 = this.m_patternMap[n];
        return n2 >= 10000 ? n2 - 10000 : n2;
    }

    private int mapNSTokens(String string, int n, int n2, int n3) throws TransformerException {
        String string2;
        String string3;
        block8: {
            string3 = string.substring(n, n2);
            if (this.m_namespaceContext != null && !string3.equals("*") && !string3.equals("xmlns")) {
                try {
                    if (string3.length() > 0) {
                        string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                        break block8;
                    }
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
                catch (ClassCastException classCastException) {
                    string2 = this.m_namespaceContext.getNamespaceForPrefix(string3);
                }
            } else {
                string2 = string3;
            }
        }
        if (string2 != null && string2.length() > 0) {
            this.addToTokenQueue(string2);
            this.addToTokenQueue(":");
            String string4 = string.substring(n2 + 1, n3);
            if (string4.length() > 0) {
                this.addToTokenQueue(string4);
            }
        } else {
            this.m_processor.error(52, new String[]{string3});
        }
        return -1;
    }

    private boolean mapPatternElemPos(int n, boolean bl, boolean bl2) {
        if (n == 0) {
            if (this.m_patternMapSize >= this.m_patternMap.length) {
                int[] nArray = this.m_patternMap;
                int n2 = this.m_patternMap.length;
                this.m_patternMap = new int[this.m_patternMapSize + 100];
                System.arraycopy(nArray, 0, this.m_patternMap, 0, n2);
            }
            if (!bl) {
                int n3 = this.m_patternMapSize - 1;
                this.m_patternMap[n3] = this.m_patternMap[n3] - 10000;
            }
            this.m_patternMap[this.m_patternMapSize] = this.m_compiler.m_tokenQueueSize - (bl2 ? 1 : 0) + 10000;
            ++this.m_patternMapSize;
            bl = false;
        }
        return bl;
    }

    private void recordTokenString(Vector vector) {
        int n = this.getTokenQueuePosFromMap(this.m_patternMapSize - 1);
        this.resetTokenMark(n + 1);
        if (this.m_processor.lookahead('(', 1)) {
            int n2 = this.getKeywordToken(this.m_processor.m_token);
            switch (n2) {
                case 1030: {
                    vector.addElement("#comment");
                    break;
                }
                case 1031: {
                    vector.addElement("#text");
                    break;
                }
                case 1033: {
                    vector.addElement("*");
                    break;
                }
                case 35: {
                    vector.addElement("/");
                    break;
                }
                case 36: {
                    vector.addElement("*");
                    break;
                }
                case 1032: {
                    vector.addElement("*");
                    break;
                }
                default: {
                    vector.addElement("*");
                    break;
                }
            }
        } else {
            if (this.m_processor.tokenIs('@')) {
                this.resetTokenMark(++n + 1);
            }
            if (this.m_processor.lookahead(':', 1)) {
                n += 2;
            }
            vector.addElement(this.m_compiler.m_tokenQueue[n]);
        }
    }

    private final void resetTokenMark(int n) {
        int n2 = this.m_compiler.m_tokenQueueSize;
        int n3 = n > 0 ? (n <= n2 ? n - 1 : n) : (this.m_processor.m_queueMark = 0);
        if (this.m_processor.m_queueMark < n2) {
            this.m_processor.m_token = (String)this.m_compiler.m_tokenQueue[this.m_processor.m_queueMark++];
            this.m_processor.m_tokenChar = this.m_processor.m_token.charAt(0);
        } else {
            this.m_processor.m_token = null;
            this.m_processor.m_tokenChar = '\u0000';
        }
    }

    void tokenize(String string) throws TransformerException {
        this.tokenize(string, null);
    }

    void tokenize(String string, Vector vector) throws TransformerException {
        this.m_compiler.m_tokenQueueSize = 0;
        this.m_compiler.m_currentPattern = string;
        this.m_patternMapSize = 0;
        this.m_compiler.m_opMap = new int[2500];
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            switch (c) {
                case '\"': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                    }
                    n2 = n5++;
                    while (n5 < n && (c = string.charAt(n5)) != '\"') {
                        ++n5;
                    }
                    if (c == '\"') {
                        this.addToTokenQueue(string.substring(n2, n5 + 1));
                        n2 = -1;
                        break;
                    }
                    this.m_processor.error(26, null);
                    break;
                }
                case '\'': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                    }
                    n2 = n5++;
                    while (n5 < n && (c = string.charAt(n5)) != '\'') {
                        ++n5;
                    }
                    if (c == '\'') {
                        this.addToTokenQueue(string.substring(n2, n5 + 1));
                        n2 = -1;
                        break;
                    }
                    this.m_processor.error(27, null);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 == -1) break;
                    bl3 = false;
                    bl = this.mapPatternElemPos(n4, bl, bl2);
                    bl2 = false;
                    if (n3 != -1) {
                        n3 = this.mapNSTokens(string, n2, n3, n5);
                    } else {
                        this.addToTokenQueue(string.substring(n2, n5));
                    }
                    n2 = -1;
                    break;
                }
                case '@': {
                    bl2 = true;
                }
                case '-': {
                    if (c == '-') {
                        if (!bl3 && n2 != -1) break;
                        bl3 = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (n2 != -1) {
                        bl3 = false;
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                        if (n3 != -1) {
                            n3 = this.mapNSTokens(string, n2, n3, n5);
                        } else {
                            this.addToTokenQueue(string.substring(n2, n5));
                        }
                        n2 = -1;
                    } else if (c == '/' && bl) {
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                    } else if (c == '*') {
                        bl = this.mapPatternElemPos(n4, bl, bl2);
                        bl2 = false;
                    }
                    if (n4 == 0 && c == '|') {
                        if (vector != null) {
                            this.recordTokenString(vector);
                        }
                        bl = true;
                    }
                    if (c == ')' || c == ']') {
                        --n4;
                    } else if (c == '(' || c == '[') {
                        ++n4;
                    }
                    this.addToTokenQueue(string.substring(n5, n5 + 1));
                    break;
                }
                case ':': {
                    if (n3 == n5 - 1) {
                        if (n2 != -1 && n2 < n5 - 1) {
                            this.addToTokenQueue(string.substring(n2, n5 - 1));
                        }
                        bl3 = false;
                        bl2 = false;
                        n2 = -1;
                        n3 = -1;
                        this.addToTokenQueue(string.substring(n5 - 1, n5 + 1));
                        break;
                    }
                    n3 = n5;
                }
                default: {
                    if (n2 == -1) {
                        n2 = n5;
                        bl3 = Character.isDigit(c);
                        break;
                    }
                    if (!bl3) break;
                    bl3 = Character.isDigit(c);
                }
            }
            ++n5;
        }
        if (n2 != -1) {
            bl3 = false;
            bl = this.mapPatternElemPos(n4, bl, bl2);
            if (n3 != -1) {
                n3 = this.mapNSTokens(string, n2, n3, n);
            } else {
                this.addToTokenQueue(string.substring(n2, n));
            }
        }
        if (this.m_compiler.m_tokenQueueSize == 0) {
            this.m_processor.error(28, null);
        } else if (vector != null) {
            this.recordTokenString(vector);
        }
        this.m_processor.m_queueMark = 0;
    }
}

