/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   Copyright (C) 2000 Trolltech AS.  All rights reserved.                *
*   info@trolltech.com                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "databaseconnection.h"

#include <qmessagebox.h>
#include <qapplication.h>
#include <qsqldatabase.h>
#include <qsqlrecord.h>
#include <qdatatable.h>

#include <kdebug.h>

DatabaseConnection::~DatabaseConnection()
{
    delete conn;
}

bool DatabaseConnection::refreshCatalog()
{
    if ( loaded )
        return true;
    if ( !open() )
        return false;
    tbls = conn->tables( QSql::TableType( QSql::Tables | QSql::Views ) );
    flds.clear();
    for ( QStringList::Iterator it = tbls.begin(); it != tbls.end(); ++it )
    {
        QSqlRecord fil = conn->record( *it );
        QStringList lst;
        for ( uint j = 0; j < fil.count(); ++j )
        {
            lst << fil.field( j ) ->name();
        }
        flds.insert( *it, lst );
    }
    loaded = true;
    conn->close();
    return loaded;
}

void DatabaseConnection::remove
    ()
{
    if ( nm == "(default)" )
        QSqlDatabase::removeDatabase( QSqlDatabase::defaultConnection );
    else
        QSqlDatabase::removeDatabase( nm );
    // the above will effectively delete the current connection
    conn = 0;
}

bool DatabaseConnection::open( bool suppressDialog )
{
    // register our name, if nec
    if ( nm == "(default)" )
    {
        if ( !QSqlDatabase::contains() )              // default doesn't exists?
            conn = QSqlDatabase::addDatabase( drv );
        else
            conn = QSqlDatabase::database();
    }
    else
    {
        if ( !QSqlDatabase::contains( nm ) )
            conn = QSqlDatabase::addDatabase( drv, nm );
        else
            conn = QSqlDatabase::database( nm );
    }
    conn->setDatabaseName( dbName );
    conn->setUserName( uname );
    conn->setPassword( pword );
    conn->setHostName( hname );
    conn->setPort( prt );
    bool success = conn->open();
    for ( ; suppressDialog == false ; )
    {
        bool done = false;
        if ( !success )
        {
            done = true;
        }
        if ( done )
            break;
        conn->setUserName( uname );
        conn->setPassword( pword );
        conn->setHostName( hname );
        conn->setPort( prt );
        success = conn->open();
        if ( !success )
        {
            switch ( QMessageBox::warning( NULL, QApplication::tr( "Connection" ),
                                           QApplication::tr( "Could not connect to the database.\n"
                                                             "Press 'OK' to continue or 'Cancel' to "
                                                             "specify different\nconnection information.\n" )
                                           + QString( "[" + conn->lastError().driverText() + "\n" +
                                                      conn->lastError().databaseText() + "]\n" ),
                                           QApplication::tr( "&OK" ),
                                           QApplication::tr( "&Cancel" ), QString::null, 0, 1 ) )
            {
            case 0:              // OK or Enter
                continue;
            case 1:              // Cancel or Escape
                done = true;
                break;
            }
        }
        else
            break;
        if ( done )
            break;
    }
    if ( !success )
    {
        dbErr = conn->lastError().driverText() + "\n" + conn->lastError().databaseText();
        remove
            ();
    }
    return success;
}

bool DatabaseConnection::isOpen()
{
    if ( !conn )
        return false;

    return conn->isOpen();
}

void DatabaseConnection::close()
{
    if ( !loaded )
        return ;

    if ( conn )
        conn->close();
}

QVariant::Type DatabaseConnection::getFieldType( const QString& t, const QString& f )
{
    if ( !conn->isOpen() )
        if ( !open() )
            return QVariant::Invalid;

    return conn->recordInfo( t ).find( f ).type();
}

int DatabaseConnection::getFieldIsRequired( const QString& t, const QString& f )
{
    if ( !conn->isOpen() )
        if ( !open() )
            return -1;

    return conn->recordInfo( t ).find( f ).isRequired();
}

