/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "connectioneditordialogimpl.h"

#include "project.h"
#include "datatable.h"
#include "databaseconnection.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

ConnectionEditorDialog::ConnectionEditorDialog( DataTable *dataTable,
                                                QWidget *parent,
                                                const char *name )
        : ConnectionEditorDialogBase( parent, name ),
        m_dataTable( dataTable )
{
    setCaption( i18n("Connection Editor Dialog") );

    setup();
}

ConnectionEditorDialog::~ConnectionEditorDialog()
{}

void ConnectionEditorDialog::setup()
{
    DatabaseConnection * conn = m_dataTable->project()->databaseConnection( m_dataTable->connection() );

    if ( !conn )
        return;

    editName->setEnabled( false );
    editName->setText( conn->name() );
    comboDriver->setEnabled( false );
    comboDriver->lineEdit() ->setText( conn->driver() );
    editDatabase->setEnabled( false );
    editDatabase->setText( conn->database() );

    editUsername->setEnabled( true );
    editUsername->setText( conn->username() );
    editPassword->setEnabled( true );
    editPassword->setText( conn->password() );
    editHostname->setEnabled( true );
    editHostname->setText( conn->hostname() );
    editPort->setEnabled( true );
    editPort->setValue( conn->port() );
    buttonConnect->setEnabled( true );
}

void ConnectionEditorDialog::doConnect()
{
    DatabaseConnection * old = m_dataTable->project()->databaseConnection( m_dataTable->connection() );

    if ( !old )
        return;

    DatabaseConnection * conn = new DatabaseConnection();
    conn->setName( editName->text() );
    conn->setDriver( comboDriver->lineEdit() ->text() );
    conn->setDatabase( editDatabase->text() );
    conn->setUsername( editUsername->text() );
    conn->setPassword( editPassword->text() );
    conn->setHostname( editHostname->text() );
    conn->setPort( editPort->value() );
    if ( conn->refreshCatalog() )
    {
        m_dataTable->project()->removeDatabaseConnection( old->name() );
        m_dataTable->project()->addDatabaseConnection( conn );
        accept();
    }
    else
    {
        QMessageBox::warning( NULL, i18n( "Connection" ),
                              QString( i18n("Could not connect to the database.\n"
                                            "Please ensure that the database server is running "
                                            "and that all the connection information is correct.\n") +
                                       "[ " + conn->lastError() + " ]" ) );
        delete conn;
    }
}

void ConnectionEditorDialog::accept()
{
    DatabaseConnection * conn = m_dataTable->project()->databaseConnection( m_dataTable->connection() );
    if ( !conn )
        return;

    if ( !conn->isOpen() )
        conn->open( false );

    ConnectionEditorDialogBase::accept();
}

void ConnectionEditorDialog::reject()
{
    ConnectionEditorDialogBase::reject();
}

#include "connectioneditordialogimpl.moc"
