/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktableedit.h"
#include "kcompletiontable.h"

#include <kdebug.h>

KTableEdit::KTableEdit( QWidget *parent, const char *name )
        : KLineEdit( parent, name )
{
}

void KTableEdit::setText( const QString &txt )
{
/*    kdDebug() << txt << endl;*/
    QString temp = txt;
    temp.truncate( txt.find( '|' ) );
    KLineEdit::setText( temp );
    emit trueTextChanged( txt );
}

void KTableEdit::setTextFromCombo( const QString &txt )
{
/*    kdDebug() << txt << endl;*/
    QString temp = txt;
    temp.truncate( txt.find( '|' ) );
    setText( temp );
    end( false ); // force cursor at end
}

void KTableEdit::setCompletedText( const QString &txt )
{
//     kdDebug() << txt << endl;
    QString temp = txt;
    temp.truncate( txt.find( '|' ) );
    KLineEdit::setCompletedText( txt );
}

void KTableEdit::setCompletedText( const QString &txt, bool marked )
{
/*    kdDebug() << txt << endl;*/
    QString temp = txt;
    temp.truncate( txt.find( '|' ) );
    KLineEdit::setCompletedText( temp, marked );
}

#include "ktableedit.moc"
