/* Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com */
package com.db4odoc.noclasses.client;

import java.io.IOException;
import java.util.List;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Candidate;
import com.db4o.query.Evaluation;
import com.db4o.query.Predicate;
import com.db4o.query.Query;

public class Client {

	private static int COUNT = 10;

	public static void main(String[] args) throws Exception {
		savePilots();
		getPilotsQBE();
		getPilotsSODA();
		getPilotsNative();
		getPilotsNativeUnoptimized();
		getPilotsEvaluation();
		saveMultiArray();
		getMultiArray();
	}
	// end main

	private static void savePilots() throws IOException {
		System.out.println("Saving Pilot objects without Pilot class on the server");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o",
				"db4o");
		try {
			for (int i = 0; i < COUNT; i++) {
				oc.set(new Pilot("Pilot #" + i, i));
			}

		} finally {
			oc.close();
		}
	}
	// end savePilots

	private static void getPilotsQBE() throws IOException {
		System.out.println("Retrieving Pilot objects: QBE");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			ObjectSet result = oc.get(new Pilot(null,0));
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getPilotsQBE
	
	private static void getPilotsSODA() throws IOException {
		System.out.println("Retrieving Pilot objects: SODA");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			Query query = oc.query();

			query.constrain(Pilot.class);
			query.descend("points").constrain(5);

			ObjectSet result = query.execute();
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getPilotsSODA

	private static void getPilotsEvaluation() throws IOException {
		System.out.println("Retrieving Pilot objects: Evaluation");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			Query query = oc.query();

			query.constrain(Pilot.class);
			query.constrain(new Evaluation(){
				public void evaluate(Candidate candidate) {
					Pilot pilot = (Pilot) candidate.getObject();
					candidate.include(pilot.getPoints() % 2 == 0);
				}
			});
			ObjectSet result = query.execute();
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getPilotsEvaluation

	private static void getPilotsNative() throws IOException {
		System.out.println("Retrieving Pilot objects: Native Query");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			List <Pilot> result = oc.query(new Predicate<Pilot>() {
	    	    public boolean match(Pilot pilot) {
	    	        return pilot.getPoints() == 5;
	    	    }
	    	});
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getPilotsNative

	private static void getPilotsNativeUnoptimized() throws IOException {
		System.out.println("Retrieving Pilot objects: Native Query Unoptimized");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			List <Pilot> result = oc.query(new Predicate<Pilot>() {
	    	    public boolean match(Pilot pilot) {
	    	        return pilot.getPoints() % 2 == 0;
	    	    }
	    	});
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getPilotsNativeUnoptimized

	private static void saveMultiArray() throws IOException {
		System.out.println("Testing saving an object with multidimentional array field");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			RecordBook recordBook = new RecordBook();
			recordBook.addRecord("September 2006", "Michael Schumacher", "last race");
			recordBook.addRecord("September 2006", "Kimi Raikkonen", "no notes");
			oc.set(recordBook);
		} finally {
			oc.close();
		}
	}
	// end saveMultiArray
	
	private static void getMultiArray() throws IOException {
		System.out.println("Testing retrieving an object with multidimentional array field");
		ObjectContainer oc = Db4o.openClient("localhost", 0xdb40, "db4o","db4o");
		try {
			ObjectSet result = oc.get(new RecordBook());
			listResult(result);
		} finally {
			oc.close();
		}
	}
	// end getMultiArray
	
	public static void listResult(ObjectSet result) {
        System.out.println(result.size());
        while(result.hasNext()) {
            System.out.println(result.next());
        }
    }
    // end listResult
	
	public static void listResult(List result) {
        System.out.println(result.size());
        for(int x = 0; x < result.size(); x++){
    		System.out.println(result.get(x));
        }
    }
    // end listResult
	
}
