/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Assorted
{
	public class PersistStaticFieldValuesTestCase : Db4oUnit.Extensions.AbstractDb4oTestCase
	{
		public class Data
		{
			public static readonly Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 ONE = new Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				();

			public static readonly Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 TWO = new Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				();

			public static readonly Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 THREE = new Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				();

			public Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 one;

			public Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 two;

			public Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.PsfvHelper
				 three;
		}

		protected override void Configure(Db4objects.Db4o.Config.IConfiguration config)
		{
			config.ObjectClass(typeof(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data)
				).PersistStaticFieldValues();
		}

		protected override void Store()
		{
			Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data psfv = 
				new Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data(
				);
			psfv.one = Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.ONE;
			psfv.two = Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.TWO;
			psfv.three = Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.THREE;
			Store(psfv);
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data psfv = 
				(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data)RetrieveOnlyInstance
				(typeof(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data)
				);
			Db4oUnit.Assert.AreSame(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.ONE, psfv.one);
			Db4oUnit.Assert.AreSame(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.TWO, psfv.two);
			Db4oUnit.Assert.AreSame(Db4objects.Db4o.Tests.Common.Assorted.PersistStaticFieldValuesTestCase.Data
				.THREE, psfv.three);
		}

		public class PsfvHelper
		{
		}
	}
}
