/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Cluster
{
	/// <exclude></exclude>
	public class ClusterQuery : Db4objects.Db4o.Query.IQuery
	{
		private readonly Db4objects.Db4o.Cluster.Cluster _cluster;

		private readonly Db4objects.Db4o.Query.IQuery[] _queries;

		public ClusterQuery(Db4objects.Db4o.Cluster.Cluster cluster, Db4objects.Db4o.Query.IQuery[]
			 queries)
		{
			_cluster = cluster;
			_queries = queries;
		}

		public virtual Db4objects.Db4o.Query.IConstraint Constrain(object constraint)
		{
			lock (_cluster)
			{
				Db4objects.Db4o.Query.IConstraint[] constraints = new Db4objects.Db4o.Query.IConstraint
					[_queries.Length];
				for (int i = 0; i < constraints.Length; i++)
				{
					constraints[i] = _queries[i].Constrain(constraint);
				}
				return new Db4objects.Db4o.Internal.Cluster.ClusterConstraint(_cluster, constraints
					);
			}
		}

		public virtual Db4objects.Db4o.Query.IConstraints Constraints()
		{
			lock (_cluster)
			{
				Db4objects.Db4o.Query.IConstraint[] constraints = new Db4objects.Db4o.Query.IConstraint
					[_queries.Length];
				for (int i = 0; i < constraints.Length; i++)
				{
					constraints[i] = _queries[i].Constraints();
				}
				return new Db4objects.Db4o.Internal.Cluster.ClusterConstraints(_cluster, constraints
					);
			}
		}

		public virtual Db4objects.Db4o.Query.IQuery Descend(string fieldName)
		{
			lock (_cluster)
			{
				Db4objects.Db4o.Query.IQuery[] queries = new Db4objects.Db4o.Query.IQuery[_queries
					.Length];
				for (int i = 0; i < queries.Length; i++)
				{
					queries[i] = _queries[i].Descend(fieldName);
				}
				return new Db4objects.Db4o.Internal.Cluster.ClusterQuery(_cluster, queries);
			}
		}

		public virtual Db4objects.Db4o.IObjectSet Execute()
		{
			lock (_cluster)
			{
				return new Db4objects.Db4o.Internal.Query.ObjectSetFacade(new Db4objects.Db4o.Internal.Cluster.ClusterQueryResult
					(_cluster, _queries));
			}
		}

		public virtual Db4objects.Db4o.Query.IQuery OrderAscending()
		{
			throw new System.NotSupportedException();
		}

		public virtual Db4objects.Db4o.Query.IQuery OrderDescending()
		{
			throw new System.NotSupportedException();
		}

		public virtual Db4objects.Db4o.Query.IQuery SortBy(Db4objects.Db4o.Query.IQueryComparator
			 comparator)
		{
			throw new System.NotSupportedException();
		}
	}
}
