/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Convert
{
	/// <exclude></exclude>
	public class Converter
	{
		public const int VERSION = Db4objects.Db4o.Internal.Convert.Conversions.FieldIndexesToBTrees_5_7
			.VERSION;

		private static Db4objects.Db4o.Internal.Convert.Converter _converter;

		private Db4objects.Db4o.Foundation.Hashtable4 _conversions;

		private Converter()
		{
			_conversions = new Db4objects.Db4o.Foundation.Hashtable4();
			Db4objects.Db4o.Internal.Convert.Conversions.CommonConversions.Register(this);
		}

		public static bool Convert(Db4objects.Db4o.Internal.Convert.ConversionStage stage
			)
		{
			if (!NeedsConversion(stage.SystemData()))
			{
				return false;
			}
			if (_converter == null)
			{
				_converter = new Db4objects.Db4o.Internal.Convert.Converter();
			}
			return _converter.RunConversions(stage);
		}

		private static bool NeedsConversion(Db4objects.Db4o.Internal.SystemData systemData
			)
		{
			return systemData.ConverterVersion() < VERSION;
		}

		public virtual void Register(int idx, Db4objects.Db4o.Internal.Convert.Conversion
			 conversion)
		{
			if (_conversions.Get(idx) != null)
			{
				throw new System.InvalidOperationException();
			}
			_conversions.Put(idx, conversion);
		}

		public virtual bool RunConversions(Db4objects.Db4o.Internal.Convert.ConversionStage
			 stage)
		{
			Db4objects.Db4o.Internal.SystemData systemData = stage.SystemData();
			if (!NeedsConversion(systemData))
			{
				return false;
			}
			for (int i = systemData.ConverterVersion(); i <= VERSION; i++)
			{
				Db4objects.Db4o.Internal.Convert.Conversion conversion = (Db4objects.Db4o.Internal.Convert.Conversion
					)_conversions.Get(i);
				if (conversion != null)
				{
					stage.Accept(conversion);
				}
			}
			return true;
		}
	}
}
