/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System;
using Sharpen.Lang;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Types;

namespace Db4objects.Db4o {

   internal class P2Collections : IDb4oCollections {

      internal IExtObjectContainer i_stream;
      
      internal P2Collections(Object a_stream) : base() {
         i_stream = (IExtObjectContainer)a_stream;
      }
      
      public IDb4oList NewLinkedList() {
          lock(i_stream.Lock()){
              if (Unobfuscated.CreateDb4oList(i_stream)){
                  IDb4oList l = new P2LinkedList();
                  i_stream.Set(l);
                  return l;
              }
              return null;
          }
      }
      
      public IDb4oMap NewHashMap(int size) {
          lock(i_stream.Lock()){
              if (Unobfuscated.CreateDb4oList(i_stream)) return new P2HashMap(size);
              return null;
          }
      }

       public IDb4oMap NewIdentityHashMap(int size) {
           lock(i_stream.Lock()){
               if(Unobfuscated.CreateDb4oList(i_stream)){
                   P2HashMap m = new P2HashMap(size);
                   m.i_type = 1;
                   i_stream.Set(m);
                   return m;
               }
               return null;
           }
       }
   }
}