#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gui_layout.h"
#include "gui_define.h"
#include "main.h"
#include "bittorrent_clist.h"
#include "bt_support.h"

gboolean
on_bittorrent_treeview_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->button==3)
	{  /* right-click */
		gtk_menu_popup(GTK_MENU(bt_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

	return FALSE;
}


gboolean
on_bittorrent_treeview_key_press_event (GtkWidget		 *widget,
													 GdkEventKey	  *event,
                                        gpointer         user_data)
{
#warning to code
  return FALSE;
}


/*********************************************************************/
/* for each selected entry of bt_treeview, attempt to start a client */
/*********************************************************************/
static void start_bt_from_bt_clist(GtkTreeModel *gtm, GtkTreePath *path, GtkTreeIter *iter, gpointer misc)
{
	gint row_btpid;

	gtk_tree_model_get(gtm,iter,BTC_BITTORRENT_PID,&row_btpid,-1);
	resume_bittorrent_by_pid(row_btpid);
}

void
on_start_bt_entry_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	generic_selected_bittorrent_clist_calls( start_bt_from_bt_clist,NULL);
}

/***************************************************************************/
/* for each selected entry of bt_treeview, attempt to terminate the client */
/***************************************************************************/
static void stop_bt_from_bt_clist(GtkTreeModel *gtm, GtkTreePath *path, GtkTreeIter *iter, gpointer misc)
{
	gint row_btpid;

	gtk_tree_model_get(gtm,iter,BTC_BITTORRENT_PID,&row_btpid,-1);
	if(!is_a_dead_bittorrent(row_btpid))
	{
		/* to terminate a bittorrent client, we just send a SIGINT (=ctrl-c) */
		kill(row_btpid,SIGINT);
	}
}

void
on_stop_bt_entry_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	generic_selected_bittorrent_clist_calls( stop_bt_from_bt_clist,NULL);
}

/********************************************************************************************************/
/* for each selected entry of bt_treeview, remove the client files (clients have been killed previously */
/********************************************************************************************************/
static void delete_bt_from_bt_clist(GtkTreeModel *gtm, GtkTreePath *path, GtkTreeIter *iter, gpointer misc)
{
	gint row_btpid;

	gtk_tree_model_get(gtm,iter,BTC_BITTORRENT_PID,&row_btpid,-1);
	if(!is_a_dead_bittorrent(row_btpid))
	{
		/* client is not dead as it should be, violently kill it */
		kill(row_btpid,SIGKILL);
	}

	delete_bittorrent_file(row_btpid,TRUE);		/* wipe all files */
}

void
on_clear_selected_bt_entries_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	generic_selected_bittorrent_clist_calls( stop_bt_from_bt_clist,NULL);
	usleep(250000);		/* wait 1/4s to let client die properly */
	generic_selected_bittorrent_clist_calls(delete_bt_from_bt_clist,NULL);
}


gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gui_full_save(widget,NULL);
	gtk_widget_destroy(widget);
	gtk_main_quit();

	return FALSE;
}

