/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * init_fnc.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: init_fnc.c,v 1.1 2003/12/26 14:31:52 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/file.h>
#include <signal.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <linux/sem.h>		/* for the value of SEMVMX */
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <gnome.h>

#include "misc_gtk.h"
#include "init_fnc.h"
#include "main.h"
#include "gui_layout.h"
#include "gui_define.h"
#include "done_clist.h"
#include "callbacks.h"

/**************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one */
/**************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		gchar *str;

		gtk_tree_model_get(gtm,iter,column_number,&str,-1);

		if((str!=NULL)&&(!strcmp(string,str)))
		{
			g_free(str);
			return TRUE;
		}
		if(str)
			g_free(str);

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/*********************************************************************************************************/
/* search in the given treemodel, in the given column a string matching the given one (case insensitive) */
/*********************************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_string_nocase(GtkTreeModel *gtm, int column_number, const char *string, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		gchar *str;

		gtk_tree_model_get(gtm,iter,column_number,&str,-1);

		if((str!=NULL)&&(!strcasecmp(string,str)))
		{
			g_free(str);
			return TRUE;
		}
		if(str)
			g_free(str);

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/*************************************************************************************/
/* search in the given treemodel, in the given column a value matching the given one */
/*************************************************************************************/
/* output: FALSE= not found, else TRUE= iter is the found row */
/**************************************************************/
int get_iter_from_ulong(GtkTreeModel *gtm, int column_number, const unsigned long value, GtkTreeIter *iter)
{
	int valid;

	valid=gtk_tree_model_get_iter_first (gtm, iter);

	while(valid)
	{
		unsigned long v;

		gtk_tree_model_get(gtm,iter,column_number,&v,-1);

		if(v==value)
			return TRUE;

		valid = gtk_tree_model_iter_next (gtm, iter);
	}
	return valid;
}

/***************************************************/
/* check if the given gtk_tree_model contains rows */
/***************************************************/
/* output: TRUE: yes, FALSE: no, it is empty */
/*********************************************/
int gtk_tree_model_is_not_empty(GtkTreeModel *gtm)
{
	GtkTreeIter iter;

	return gtk_tree_model_get_iter_first(gtm,&iter);
}

/********************************************************************************************************************/
/* the following function makes some adjustements that cannot be done inside glade (or I don't know how to do them) */
/********************************************************************************************************************/
void init_clist(void)
{
	load_all_done_lists();
}

	
