/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * recent_hub_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: recent_hub_clist.c,v 1.6 2003/12/27 11:27:01 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <signal.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "recent_hub_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "status.h"
#include "init_fnc.h"
#include "gtk_helper.h"

static GtkListStore *build_empty_recent_hub_clist(void);

/*******************************************************************************/
/* fill the clist named "hub_recent_clist" with the list of all running client */
/*******************************************************************************/
void fill_recent_hub_clist(void)
{
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkListStore *gls;
	GString *s;
	char *path;
	FILE *f;
	GHashTable *ght;
	SORT_VARS( )

	w=get_widget_by_widget_name(main_window,"hub_recent_clist");
	if(w==NULL)
		return;

	gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w));

	/* save current sort order */
	SORT_GET(,gtm)

	gls=build_empty_recent_hub_clist();
	gtm=GTK_TREE_MODEL(gls);
	ght=g_hash_table_new_full(g_str_hash,g_str_equal,g_free,NULL);

	s=g_string_new(NULL);
	path=getenv("HOME");
	g_string_sprintf(s,"%s/.dctc/recent",(path!=NULL)?path:".");

	/* we read the file ~/.dctc/recent */
	f=fopen(s->str,"rb");
	if(f!=NULL)
	{
		char buf[51200];

		while(fgets(buf,sizeof(buf),f)!=NULL)
		{
			char *addr=buf;
			char *hubname=strchr(buf,'|');

			if(addr!=NULL)
			{
				char *t;
				*(hubname)++='\0';

				t=strchr(hubname,'\n');
				if(t!=NULL)
				{
					GtkTreeIter iter;

					*t='\0';

					if(g_hash_table_lookup(ght,addr)==NULL)
					{
						/* only add if no other hub has the same address */
						{
							/* update the hash table */
							gchar *gch;

							gch=g_strdup(addr);
							g_hash_table_insert(ght,gch,gch);
						}
	
						gtk_list_store_append (gls, &iter);
						if(utf8_mode==TRUE)
						{
							gtk_list_store_set(gls,&iter,REHC_HUB_NAME_COL,hubname,
																	REHC_HUB_ADDR_COL,addr,
																	REHC_HUB_NAME,hubname,
																	REHC_DUMMY,(gint)0,
																	-1);
						}
						else
						{
							gchar *utf8;

							utf8=g_locale_to_utf8(hubname,-1,NULL,NULL,NULL);
							gtk_list_store_set(gls,&iter,REHC_HUB_NAME_COL,utf8,
																	REHC_HUB_ADDR_COL,addr,
																	REHC_HUB_NAME,hubname,
																	REHC_DUMMY,(gint)0,
																	-1);
							g_free(utf8);
						}
					}
				}
			}
		}

		fclose(f);
	}

	/* restore original sort order */
	SORT_RESTORE(,gtm)

	g_hash_table_destroy(ght);

	/* install the new store in place of the current want (will be automatically released) */
	gtk_tree_view_set_model(GTK_TREE_VIEW(w),gtm);

	g_string_free(s,TRUE);
}

/***************************************/
/* create an empty store for this list */
/***************************************/
static GtkListStore *build_empty_recent_hub_clist(void)
{
   return gtk_list_store_new(NB_REHC_COL, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
}

/**************************************************/
/* build modele and view for the recent hub clist */
/**************************************************/
void bmav4_recent_hub_clist(void)
{
   GtkListStore *model;
   GtkWidget *view;
   GtkCellRenderer *rend;
   GtkTreeSelection *slc;

	model=build_empty_recent_hub_clist();

   view=get_widget_by_widget_name(main_window,"hub_recent_clist");

   gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
   gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

   slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
   gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);

   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),REHC_HUB_NAME_COL,_("Hubname"),rend,"text",REHC_HUB_NAME_COL,NULL);

   rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
   MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),REHC_HUB_ADDR_COL,_("Address"),rend,"text",REHC_HUB_ADDR_COL,NULL);

   /* The view now holds a reference.  We can get rid of our own
    * reference */
   g_object_unref (G_OBJECT (model));
}


