<?php
/*
 * $Id: class.dbFaqanswers.inc.php,v 1.2.4.1 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbFaqanswers extends dclDB
{
	var $answerid;
	var $questionid;
	var $answertext;
	var $createby;
	var $createon;
	var $modifyby;
	var $modifyon;
	var $active;

	function dbFaqanswers()
	{
           // Table Fields
		$this->fieldArray = array(
				'answerid',
				'questionid', 
				'answertext', 
				'createby', 
				'createon', 
				'modifyby', 
				'modifyon', 
				'active');

           // Foreign keys
		$this->foreignKeys = array();

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('faqanswers');
		$query = 'INSERT INTO faqanswers (';
		if ($idSQL != '')
			$query .= 'answerid,';
		$query .= 'questionid,answertext,createby,createon,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->questionid . ',';
		$query .= '\'' . $this->DBAddSlashes($this->answertext) . '\',';
		$query .= $this->DBAddSlashes($this->createby) . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= '\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_FAQANSWERINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE faqanswers SET ';
		$query .= 'questionid=' . $this->questionid . ',';
		$query .= 'answertext=\'' . $this->DBAddSlashes($this->answertext) . '\',';
		$query .= 'modifyby=' . $this->modifyby . ',';
		$query .= 'modifyon=' . $this->GetDateSQL() . ',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE answerid=' . $this->answerid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM faqanswers WHERE answerid=' . $this->answerid;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE faqanswers SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE answerid=' . $this->answerid;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->answerid = $this->f('answerid');
			$this->questionid = $this->f('questionid');
			$this->answertext = trim($this->f('answertext'));
			$this->createby = $this->f('createby');
			$this->createon = $this->FormatTimestampForDisplay($this->f('createon'));
			$this->modifyby = $this->f('modifyby');
			$this->modifyon = $this->FormatTimestampForDisplay($this->f('modifyon'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->answerid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT answerid, questionid, answertext, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqanswers WHERE answerid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function LoadByQuestionID($id, $orderby = 'questionid desc')
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT answerid, questionid, answertext, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqanswers WHERE questionid=$id";
		if ($orderby != '')
			$sql .= " ORDER BY $orderby";

		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function Clear()
	{
		$this->answerid = 0;
		$this->questionid = 0;
		$this->answertext = '';
		$this->createby = 0;
		$this->createon = '';
		$this->modifyby = 0;
		$this->modifyon = '';
		$this->active = '';
	}
}
?>
