<?php
/*
 * $Id: class.htmlAccounts.inc.php,v 1.2.2.2.2.9 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('acct');
LoadStringResource('wo');
LoadStringResource('tck');
LoadStringResource('prod');

class htmlAccounts
{
	function createCombo($default = 0, $cbName = 'account', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'account', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		$query = "SELECT id,$longShort FROM accounts WHERE id>0";

		if ($activeOnly)
			$query .= ' AND active=\'Y\' ';

		$query .= " ORDER BY $longShort";

		$oSelect = CreateObject('dcl.htmlSelect');
		$oSelect->vDefault = $default;
		$oSelect->sName = $cbName;
		$oSelect->iSize = $size;
		$oSelect->sZeroOption = STR_CMMN_SELECTONE;
		$oSelect->SetFromQuery($query);

		return $oSelect->GetHTML();
	}

	function ShowSearchForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlAccountsSearch.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		// Labels
		$Template->set_var('TXT_ACCOUNTSEARCH', STR_ACCT_ACCOUNTSEARCH);
		$Template->set_var('TXT_SEARCHTEXT', STR_ACCT_SEARCHTEXT);
		$Template->set_var('TXT_NAME', STR_ACCT_NAME);
		$Template->set_var('TXT_SHORTNAME', STR_ACCT_SHORT);
		$Template->set_var('TXT_CITY', STR_ACCT_CITY);
		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);

		$Template->pparse('out', 'hForm');
	}

	function ExecuteSearch($searchFld, $searchText)
	{
		global $dcl_info, $g_oSec;

		$obj = CreateObject('dcl.dbAccounts');
		$obj->Connect();

		$query = 'SELECT id,active,name,add1,add2,city,state,zip,contact,voice,fax,data1,data2 FROM accounts';
		if ($searchText != '')
			$query .= ' WHERE ' . $obj->GetUpperSQL($searchFld) . ' LIKE \'%' . strtoupper($searchText) . '%\'';
		$query .= ' ORDER BY ' . $obj->GetUpperSQL($searchFld);

		$obj->Query($query);
		$allRecs = $obj->FetchAllRows();
		if (count($allRecs) > 0)
		{
			// Format the phone numbers
			for ($i = 0; $i < count($allRecs); $i++)
				for ($j = 9; $j < 13; $j++)
					$allRecs[$i][$j] = FormatPhone($allRecs[$i][$j]);

			$allName = array(
					0 => STR_ACCT_ID,
					1  => STR_ACCT_ACTIVEABB,
					2  => STR_ACCT_NAME,
					3  => STR_ACCT_ADDRESS1,
					4  => STR_ACCT_ADDRESS2,
					5  => STR_ACCT_CITY,
					6  => STR_ACCT_STATEABB,
					7  => STR_ACCT_ZIP,
					8  => STR_ACCT_CONTACT,
					9  => STR_ACCT_CONTACTPH,
					10 => STR_ACCT_FAX,
					11 => STR_ACCT_DATA1,
					12 => STR_ACCT_DATA2);

			if (count($allRecs) > 0)
			{
				$allName[] = STR_ACCT_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=htmlAccounts.view&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_VIEW . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boWatches.add&typeid=6&whatid1=' . $allRecs[$i][0]) . '">' . STR_ACCT_WATCHWO . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boWatches.add&typeid=7&whatid1=' . $allRecs[$i][0]) . '">' . STR_ACCT_WATCHTCK . '</a>';

					if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
					{
						$options .= '&nbsp;|&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=htmlWiki.show&type=5&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_WIKI . '</a>';
					}

					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
					{
						$options .= '&nbsp;|&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAccounts.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
						$options .= '&nbsp;|&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAccounts.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					}
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_ACCT_TABLETITLE, $searchFld, $searchText));
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont(sprintf(STR_ACCT_NOTFOUND, $searchFld, $searchText));
			print('</CENTER>');
		}
	}

	function ShowDuplicates($short, $name)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbAccounts');
		$obj->Connect();

		$query = sprintf("SELECT name, %s, add1, add2, city, state, zip FROM accounts Where %s = '%s' Or %s = '%s' Order By %s",
			$obj->GetRTrimSQL('short'),
			$obj->GetRTrimSQL($obj->GetUpperSQL('short')),
			strtoupper($short),
			$obj->GetUpperSQL('name'),
			strtoupper($name),
			$obj->GetUpperSQL('name'));

		$obj->Query($query);
		$allRecs = $obj->FetchAllRows();
		if (count($allRecs) > 0)
		{
			$allName = array(
					0  => STR_ACCT_NAME,
					1  => STR_ACCT_SHORT,
					2  => STR_ACCT_ADDRESS1,
					3  => STR_ACCT_ADDRESS2,
					4  => STR_ACCT_CITY,
					5  => STR_ACCT_STATEABB,
					6  => STR_ACCT_ZIP);

			PrintArrayAsChocoTable($allName, $allRecs, 'Duplicates Encountered');
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont('No duplicates found!');
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlAccountsForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';

		// Extra check in case user is asked to change short or long name
		if ($isEdit && $obj->id > 0)
		{
			$Template->set_var('TXT_FUNCTION', STR_ACCT_EDITACCOUNT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boAccounts.dbmodify">';
			$hidden_vars .= '<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', STR_ACCT_ADDNEWACCOUNT);
			$hidden_vars .= '<input type="hidden" name="menuAction" value="boAccounts.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_ACCT_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_ACCT_SHORT);
		$Template->set_var('TXT_NAME', STR_ACCT_NAME);
		$Template->set_var('TXT_ADDRESS1', STR_ACCT_ADDRESS1);
		$Template->set_var('TXT_ADDRESS2', STR_ACCT_ADDRESS2);
		$Template->set_var('TXT_CITY', STR_ACCT_CITY);
		$Template->set_var('TXT_STATE', STR_ACCT_STATE);
		$Template->set_var('TXT_ZIP', STR_ACCT_ZIP);
		$Template->set_var('TXT_CONTACT', STR_ACCT_CONTACT);
		$Template->set_var('TXT_CONTACTPH', STR_ACCT_CONTACTPH);
		$Template->set_var('TXT_FAX', STR_ACCT_FAX);
		$Template->set_var('TXT_DATA1', STR_ACCT_DATA1);
		$Template->set_var('TXT_DATA2', STR_ACCT_DATA2);
		$Template->set_var('TXT_NOTES', STR_ACCT_NOTES);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
			$Template->set_var('VAL_ADD1', $obj->add1);
			$Template->set_var('VAL_ADD2', $obj->add2);
			$Template->set_var('VAL_CITY', $obj->city);
			$Template->set_var('VAL_STATE', $obj->state);
			$Template->set_var('VAL_ZIP', $obj->zip);
			$Template->set_var('VAL_CONTACT', $obj->contact);
			$Template->set_var('VAL_VOICE', $obj->voice);
			$Template->set_var('VAL_FAX', $obj->fax);
			$Template->set_var('VAL_DATA1', $obj->data1);
			$Template->set_var('VAL_DATA2', $obj->data2);
			$Template->set_var('VAL_NOTES', $obj->notes);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('VAL_ADD1', '');
			$Template->set_var('VAL_ADD2', '');
			$Template->set_var('VAL_CITY', '');
			$Template->set_var('VAL_STATE', '');
			$Template->set_var('VAL_ZIP', '');
			$Template->set_var('VAL_CONTACT', '');
			$Template->set_var('VAL_VOICE', '');
			$Template->set_var('VAL_FAX', '');
			$Template->set_var('VAL_DATA1', '');
			$Template->set_var('VAL_DATA2', '');
			$Template->set_var('VAL_NOTES', '');
		}

		$Template->pparse('out', 'hForm');
	}

	function GetOptionsCombo($cbName)
	{
		global $g_oSec, $dcl_info;

		$o = CreateObject('dcl.htmlSelect');
		$o->sName = $cbName;
		$o->iSize = 1;
		$o->vDefault = 'htmlAccounts.viewModules';

		$o->AddOption('htmlAccounts.viewWO', STR_PROD_VIEWWO);
		$o->AddOption('htmlAccounts.viewTck', STR_PROD_VIEWTICKETS);
		if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
			$o->AddOption('htmlWiki.show', STR_CMMN_WIKI);

		if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
		{
			$o->AddOption('boAccounts.modify', STR_CMMN_EDIT);
			$o->AddOption('boAccounts.delete', STR_CMMN_DELETE);
		}

		$o->AddOption('htmlAccounts.watchWorkOrder', STR_PROD_WOWATCH);
		$o->AddOption('htmlAccounts.watchTicket', STR_PROD_TCKWATCH);

		return $o->GetHTML();
	}

	function view()
	{
		$this->ShowDetail($GLOBALS[GetSourceArray()]['id']);
	}

	function viewWO()
	{
		$this->ShowDetail($GLOBALS[GetSourceArray()]['id']);
	}

	function viewTck()
	{
		$this->ShowDetail($GLOBALS[GetSourceArray()]['id'], 'tickets');
	}
	
	function watchWorkOrder()
	{
		$o = CreateObject('dcl.boWatches');
		$GLOBALS['typeid'] = 6;
		$o->add();
	}

	function watchTicket()
	{
		$o = CreateObject('dcl.boWatches');
		$GLOBALS['typeid'] = 7;
		$o->add();
	}

	function ShowDetail($id, $which = 'workorders')
	{
		global $dcl_info;
		
		commonHeader();

		if (!isset($id) || $id == '' || $id < 1)
		{
			PrintPermissionDenied();
			return;
		}

		$obj = CreateObject('dcl.dbAccounts');
		$obj->Connect();
		$obj->Load($id);

		$objStat = CreateObject('dcl.dbStatuses');
		$objStat->Connect($obj->conn);

		$Template = CreateTemplate(array('hForm' => 'htmlAccountDetail.tpl'));
		$Template->set_block('hForm', 'statuses', 'hStatuses');
		$Template->set_block('hForm', 'nostatuses', 'hNoStatuses');
		$Template->set_block('hForm', 'activity', 'hActivity');
		$Template->set_var('hStatuses', '');
		$Template->set_var('hNoStatuses', '');
		$Template->set_var('hActivity', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		
		// Labels
		$Template->set_var('TXT_ACTIVE', STR_CMMN_ACTIVE);
		$Template->set_var('TXT_ACTIVITY', STR_PROD_ACTIVITYLAST7DAYS);
		$Template->set_var('TXT_GO', STR_CMMN_GO);
		$Template->set_var('TXT_ACTIVE', STR_ACCT_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_ACCT_SHORT);
		$Template->set_var('TXT_NAME', STR_ACCT_NAME);
		$Template->set_var('TXT_ADDRESS1', STR_ACCT_ADDRESS1);
		$Template->set_var('TXT_ADDRESS2', STR_ACCT_ADDRESS2);
		$Template->set_var('TXT_CITY', STR_ACCT_CITY);
		$Template->set_var('TXT_STATE', STR_ACCT_STATE);
		$Template->set_var('TXT_ZIP', STR_ACCT_ZIP);
		$Template->set_var('TXT_CONTACT', STR_ACCT_CONTACT);
		$Template->set_var('TXT_CONTACTPH', STR_ACCT_CONTACTPH);
		$Template->set_var('TXT_FAX', STR_ACCT_FAX);
		$Template->set_var('TXT_DATA1', STR_ACCT_DATA1);
		$Template->set_var('TXT_DATA2', STR_ACCT_DATA2);
		$Template->set_var('TXT_NOTES', STR_ACCT_NOTES);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_ACCT_HIGHLIGHTEDNOTE);

		// Data
		$Template->set_var('VAL_ID', $id);
		$Template->set_var('VAL_NAME', htmlspecialchars($obj->name));
		$Template->set_var('VAL_ACTIVE', $obj->active == 'Y' ? STR_CMMN_YES : STR_CMMN_NO);
		$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
		$Template->set_var('VAL_SHORT', htmlspecialchars($obj->short));
		$Template->set_var('VAL_ADD1', htmlspecialchars($obj->add1));
		$Template->set_var('VAL_ADD2', htmlspecialchars($obj->add2));
		$Template->set_var('VAL_CITY', htmlspecialchars($obj->city));
		$Template->set_var('VAL_STATE', htmlspecialchars($obj->state));
		$Template->set_var('VAL_ZIP', htmlspecialchars($obj->zip));
		$Template->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
		$Template->set_var('VAL_VOICE', htmlspecialchars($obj->voice));
		$Template->set_var('VAL_FAX', htmlspecialchars($obj->fax));
		$Template->set_var('VAL_DATA1', htmlspecialchars($obj->data1));
		$Template->set_var('VAL_DATA2', htmlspecialchars($obj->data2));
		$Template->set_var('VAL_NOTES', nl2br(htmlspecialchars($obj->notes)));
		$Template->set_var('VAL_WIKITYPE', 5); // DCL_ENTITY_ACCOUNT

		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('CMB_ACTION', $this->GetOptionsCombo('menuAction'));

		// Quick status summary here
		if ($which == 'workorders')
			$obj->Query("SELECT status,count(*),sum(etchours),sum(totalhours) FROM workorders Left Join dcl_wo_account On workorders.jcn = dcl_wo_account.wo_id And workorders.seq = dcl_wo_account.seq WHERE account_id = $id GROUP BY status");
		else
			$obj->Query("SELECT status,count(*) FROM tickets WHERE account=$id GROUP BY status");

		if ($obj->next_record())
		{
			do
			{
				$objStat->Load($obj->f(0));
				$Template->set_var('VAL_STATUSNAME', $objStat->name);
				$Template->set_var('VAL_STATUSCOUNT', $obj->f(1));

				if ($which == 'workorders')
				{
					if ($objStat->id == 2)
						$Template->set_var('VAL_STATUSHOURS', sprintf('(%0.2fh)', $obj->f(3)));
					else
						$Template->set_var('VAL_STATUSHOURS', sprintf('(%0.2fh)', $obj->f(2)));
				}
				else
					$Template->set_var('VAL_STATUSHOURS', '');

				$Template->parse('hStatuses', 'statuses', true);
			}
			while ($obj->next_record());
		}
		else
		{
			if ($which == 'workorders')
				$Template->set_var('TXT_NOITEMS', STR_PROD_NOWORKORDERS);
			else
				$Template->set_var('TXT_NOITEMS', STR_PROD_NOTICKETS);

			$Template->parse('hNoStatuses', 'nostatuses', true);
		}

		$dt = new DCLTimestamp;
		$dtToday = new DCLTimestamp;
		$dtToday->time = time();

		$dt->time = $dtToday->time - (86400 * 7);

		$table = $which;

		if ($table == 'workorders')
			$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b, dcl_wo_account c WHERE a.jcn = c.wo_id AND a.seq = c.seq AND c.account_id=$id AND a.status=b.id AND (b.dcl_status_type!=2 or (b.dcl_status_type=2 AND a.closedon between '%s' and '%s')) AND a.createdon<'%s'", $dt->ToDB(), $dtToday->ToDB(), $dt->ToDB()));
		else
			$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b WHERE a.account=$id AND a.status=b.id AND (b.dcl_status_type!=2 or (b.dcl_status_type=2 AND a.closedon between '%s' and '%s')) AND a.createdon<'%s'", $dt->ToDB(), $dtToday->ToDB(), $dt->ToDB()));

		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_PREEXISTING);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		if ($table == 'workorders')
			$obj->Query(sprintf("SELECT count(*) FROM $table a, dcl_wo_account b WHERE a.jcn = b.wo_id AND a.seq = b.seq AND b.account_id=$id AND a.createdon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));
		else
			$obj->Query(sprintf("SELECT count(*) FROM $table WHERE account=$id AND createdon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));

		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_CREATED);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		if ($table == 'workorders')
			$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b, dcl_wo_account c WHERE a.jcn = c.wo_id AND a.seq = c.seq AND c.account_id=$id AND a.status=b.id AND b.dcl_status_type=2 AND closedon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));
		else
			$obj->Query(sprintf("SELECT count(*) FROM $table a, statuses b WHERE account=$id AND a.status=b.id AND b.dcl_status_type=2 AND closedon between '%s' and '%s'", $dt->ToDB(), $dtToday->ToDB()));

		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_CLOSED);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		if ($table == 'workorders')
			$obj->Query("SELECT count(*) FROM $table a, statuses b, dcl_wo_account c WHERE a.jcn = c.wo_id AND a.seq = c.seq AND c.account_id=$id AND a.status=b.id AND b.dcl_status_type!=2");
		else
			$obj->Query("SELECT count(*) FROM $table a, statuses b WHERE account=$id AND a.status=b.id AND b.dcl_status_type!=2");

		$obj->next_record();
		$Template->set_var('TXT_ACTIVITYTYPE', STR_PROD_OUTSTANDING);
		$Template->set_var('VAL_ACTIVITYCOUNT', $obj->f(0));
		$Template->parse('hActivity', 'activity', true);

		$Template->pparse('out', 'hForm');

		// This shows the non-closed work orders/tickets grouped by status
		$objView = CreateObject('dcl.boView');
		if ($which == 'workorders')
		{
			$objView->title = sprintf(STR_PROD_WOTITLE, $obj->name);
			$objView->style = 'report';
			$objView->table = 'workorders';
			$objView->AddDef('columns', '', array('jcn', 'seq', 'priorities.name', 'severities.name', 'responsible.short', 'deadlineon', 'summary'));
			$objView->AddDef('columnhdrs', '', array(
					STR_WO_STATUS,
					STR_WO_JCN,
					STR_WO_SEQ,
					STR_WO_PRIORITY,
					STR_WO_SEVERITY,
					STR_WO_RESPONSIBLE,
					STR_WO_DEADLINE,
					STR_WO_SUMMARY));

			$objView->AddDef('filter', 'dcl_wo_account.account_id', $id);
			$objView->AddDef('filternot', 'status', '2');
			$objView->AddDef('order', '', array('jcn', 'seq'));
			$objView->AddDef('groups', '', array('statuses.name'));
		}
		else
		{
			$objView->title = sprintf(STR_PROD_TICKETTITLE, $obj->name);
			$objView->style = 'report';
			$objView->table = 'tickets';
			$objView->AddDef('columns', '', array('ticketid', 'statuses.name', 'priorities.name', 'severities.name', 'responsible.short', 'summary'));
			$objView->AddDef('columnhdrs', '', array(
					STR_TCK_STATUS,
					STR_TCK_TICKET . '#',
					STR_TCK_STATUS,
					STR_TCK_PRIORITY,
					STR_TCK_TYPE,
					STR_TCK_RESPONSIBLE,
					STR_TCK_SUMMARY));

			$objView->AddDef('filter', 'account', $id);
			$objView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			$objView->AddDef('order', '', array('ticketid'));
			$objView->AddDef('groups', '', array('statuses.name'));
		}

		$objHV = CreateViewObject($objView->table);
		$objHV->bShowPager = false;
		$objHV->Render($objView);
	}
}
?>
