<?php
/*
 * $Id: class.htmlChecklistForm.inc.php,v 1.2.4.2 2003/04/20 00:24:58 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class htmlChecklistForm
{
	var $xml;
	var $oPersonnel;
	var $oProducts;
	var $bFirstState;
	var $oDate;
	var $oTimestamp;
	var $bIsView;
	var $oSelect;

	function htmlChecklistForm()
	{
		$this->oPersonnel = NULL;
		$this->oProducts = NULL;
		$this->oSelect = NULL;
		$this->bFirstState = true;
		$this->oDate = new DCLDate;
		$this->oTimestamp = new DCLTimestamp;
	}

	function GetNodeValue(&$node)
	{
		$this->xml->FindChildNode($node, 'Values');
		if ($this->xml->currentNode != NULL)
		{
			if (count($this->xml->currentNode->childNodes) > 1)
			{
				$aRetVal = Array();
				while (list(, $v) = each($this->xml->currentNode->childNodes))
					$aRetVal[] = $v->data;

				return $aRetVal;
			}
			elseif (count($this->xml->currentNode->childNodes) == 1)
				return $this->xml->currentNode->childNodes[0]->data;
		}

		return '';
	}

	function SetNodeValue(&$node, &$vValue)
	{
		if (is_array($vValue))
		{
			$this->xml->FindChildNode($node, 'Values');
			if ($this->xml->currentNode == NULL)
			{
				$this->xml->AddChildNode($node, 'Values', array());
				$this->xml->currentNode = &$this->xml->node->childNodes[count($this->xml->node->childNodes) - 1];
			}

			$this->xml->currentNode->childNodes = array();
			reset($vValue);
			while (list($k, $v) = each($vValue))
			{
				$this->xml->AddChildNode($this->xml->currentNode, 'Value', array());
				$oChild = &$this->xml->currentNode->childNodes[count($this->xml->currentNode->childNodes) - 1];
				$oChild->data = $v;
			}
		}
		else
		{
			$this->xml->FindChildNode($node, 'Value');
			if ($this->xml->currentNode != NULL)
				$this->xml->currentNode->data = $vValue;
		}
	}

	function RenderDate(&$node)
	{
		echo '<input type="text" size="10" maxlength="10" ';
		echo 'name="' . $node->attributes['name'] . '" ';
		echo 'id="' . $node->attributes['name'] . '" ';
		$sValue = $this->GetNodeValue($node);
		if ($sValue != '')
		{
			$this->oDate->SetFromANSI($sValue);
			echo ' value="' . $this->oDate->ToDisplay() . '"';
		}
		echo '>';
		echo GetCalendarLink($node->attributes['name']);
	}

	function RenderPersonnel(&$node)
	{
		if ($this->oSelect == NULL)
			$this->oSelect = CreateObject('dcl.htmlSelect');

		if (substr($node->attributes['type'], -3, 3) == 'one')
			$this->oSelect->iSize = 0;
		else
			$this->oSelect->iSize = 8;

		$this->oSelect->sName = $node->attributes['name'];
		$this->oSelect->vDefault = $this->GetNodeValue($node);
		$this->oSelect->sZeroOption = 'Select One';
		$this->oSelect->SetOptionsFromDb('personnel', 'short', 'short');
		$this->oSelect->Render();
	}

	function RenderProducts(&$node)
	{
		if ($this->oSelect == NULL)
			$this->oSelect = CreateObject('dcl.htmlSelect');

		if (substr($node->attributes['type'], -3, 3) == 'one')
			$this->oSelect->iSize = 0;
		else
			$this->oSelect->iSize = 8;

		$this->oSelect->sName = $node->attributes['name'];
		$this->oSelect->vDefault = $this->GetNodeValue($node);
		$this->oSelect->sZeroOption = 'Select One';
		$this->oSelect->SetOptionsFromDb('products', 'name', 'name');
		$this->oSelect->Render();
	}

	function RenderSelectOne(&$node)
	{
		$this->xml->FindChildNode($node, 'Options');
		if ($this->xml->currentNode != NULL)
		{
			echo '<select name="' . $node->attributes['name'] . '">';
			$o = &$this->xml->currentNode;
			for ($i = 0; $i < count($o->childNodes); $i++)
				echo '<option value="' . $o->childNodes[$i]->data . '">' . $o->childNodes[$i]->data . '</option>';
			echo '</select>';
		}
	}

	function RenderField(&$node)
	{
		echo '<tr>';
		echo '<td valign="top"><b>', $node->attributes['display'], ':</b></td>';
		echo '<td valign="top">';
		if ($this->bIsView)
		{
			$sVal = $this->GetNodeValue($node);
			if ($node->attributes['type'] == 'date' || $node->attributes['type'] == 'createdate')
			{
				if ($sVal != '')
				{
					$this->oDate->SetFromANSI($sVal);
					echo $this->oDate->ToDisplay();
				}
			}
			else
			{
				if (is_array($sVal))
					$sVal = implode(', ', $sVal);

				echo $sVal;
			}

			echo '</td></tr>';
			return;
		}

		switch ($node->attributes['type'])
		{
			case 'personnel-one':
			case 'personnel-multi':
				$this->RenderPersonnel($node);
				break;
			case 'products-one':
			case 'products-multi':
				$this->RenderProducts($node);
				break;
			case 'select-one':
				$this->RenderSelectOne($node);
				break;
			case 'textarea':
				echo '<textarea name="', $node->attributes['name'], '" rows="';
				echo $node->attributes['rows'], '" cols="', $node->attributes['cols'], '">';
				echo $this->GetNodeValue($node);
				echo '</textarea>';
				break;
			case 'date':
				$this->RenderDate($node);
				break;
			case 'time':
				echo '<input type="text" name="' . $node->attributes['name'];
				echo '" size="5" maxlength="5" value="';
				echo $this->GetNodeValue($node);
				echo '">';
				break;
			case 'phone':
			case 'email':
			case 'text':
				echo '<input type="text" name="' . $node->attributes['name'];
				echo '" size="' . $node->attributes['size'];
				echo '" value="';
				echo $this->GetNodeValue($node);
				echo '">';
				break;
			case 'createdate':
				$sVal = $this->GetNodeValue($node);
				if ($sVal != '')
				{
					$this->oDate->SetFromANSI($sVal);
					echo $this->oDate->ToDisplay();
				}
				echo GetHiddenVar($node->attributes['name'], $sVal);
				break;
			case 'createby':
			case 'autoincrement':
				$sVal = $this->GetNodeValue($node);
				echo $sVal;
				echo GetHiddenVar($node->attributes['name'], $sVal);
				break;
			default:
				echo $node->attributes['type'];
		}
		echo '</td></tr>';
	}

	function RenderState(&$node)
	{
		echo '<tr>';
		echo '<th colspan="2" style="background-color: #c0c0c0; text-align: left; border-bottom: 2px solid black;">', $node->attributes['name'], '</th>';
		echo '</tr>';
	}

	function RenderNode(&$node)
	{
		switch($node->name)
		{
			case 'Field':
				$this->RenderField($node);
				break;
			case 'State':
				$this->RenderState($node);
				break;
			case 'Name':
				// Render title - show state combo beneath
				echo '<tr><th colspan="2">' . $node->data . '</td></tr>';
				$this->RenderStateCombo();
				break;
		}

		if (is_array($node->childNodes))
		{
			while (list(, $child) = each($node->childNodes))
				$this->RenderNode($child);
		}
	}

	function RenderStateCombo()
	{
		$currentState = '';
		$this->xml->FindChildNode($this->xml->root, 'CurrentState');
		if ($this->xml->currentNode != NULL)
			$currentState = $this->xml->currentNode->data;

		if ($this->bIsView)
		{
			echo '<tr><th style="text-align: left;">', 'State', '</th><td>';
			echo $currentState . '</td></tr>';
			return;
		}

		$this->xml->ClearList();
		$this->xml->ListNodes($this->xml->root, 'State', 'name', '*');
		if (count($this->xml->nodes) > 0)
		{
			echo '<tr><th style="text-align: left;">', STR_CHK_STATE, '</th><td><select name="dcl_chklst_status">';
			for ($i = 0; $i < count($this->xml->nodes); $i++)
			{
				echo '<option value="', $this->xml->nodes[$i]->attributes['name'], '"';
				if ($this->xml->nodes[$i]->attributes['name'] == $currentState)
					echo ' selected';
				echo '>', $this->xml->nodes[$i]->attributes['name'], '</option>';
			}
			echo '</select></td></tr>';
		}
	}

	function show($id, $file, $bIsView = false)
	{
		commonHeader();
		IncludeCalendar();
		echo '<script language="JavaScript" src="js/formchek.js"></script>';

		$this->xml = CreateObject('dcl.xmlDoc');
		$this->xml->ParseFile($file);

		echo '<center><table border="0" cellspacing="0">';
		if (!$bIsView)
		{
			echo '<form method="post" action="' . menuLink() . '">';
			echo GetHiddenVar('menuAction', 'boChecklists.dbmodify');
			echo GetHiddenVar('dcl_chklst_id', $id);
		}
		$this->bFirstState = true;
		$this->bIsView = $bIsView;
		$this->RenderNode($this->xml->root);
		if (!$bIsView)
			echo '<tr><td colspan="2" align="center"><input type="submit" value="' . STR_CMMN_SAVE . '"></td></tr></form>';

		echo '</table></center>';
	}

	function UpdateNodes(&$node)
	{
		if (IsSet($GLOBALS[$node->attributes['name']]))
		{
			$sData = $GLOBALS[$node->attributes['name']];
			if (!is_array($sData))
			{
				if (get_magic_quotes_gpc() == 1)
					$sData = stripslashes($sData);

				if ($node->data != $sData)
					$this->SetNodeValue($node, $sData);
			}
			else
				$this->SetNodeValue($node, $sData);
		}

		for ($i = 0; $i < count($node->childNodes); $i++)
			$this->UpdateNodes($node->childNodes[$i]);
	}
}
?>
