<?php
/*
 * $Id: class.htmlTickets.inc.php,v 1.3.2.2.2.9 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tck');

class htmlTickets
{
	function GetActionCombo($include, $jcn, $seq)
	{
		global $dcl_info, $g_oSec;

		$cmbText = '<select name="menuAction">';
		$options = array();
		if (ereg('d', $include))
			$options['boTickets.view'] = STR_CMMN_VIEW;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'] && ereg('t', $include))
			$options['boTicketresolutions.add'] = STR_TCK_OPTADDRESOLUTION;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'] && ereg('a', $include))
			$options['boTickets.reassign'] = STR_TCK_OPTREASSIGN;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('e', $include))
			$options['boTickets.modify'] = STR_TCK_OPTMODIFY;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
			$options['boTickets.delete'] = STR_TCK_OPTDELETE;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('c', $include))
			$options['boTickets.copyToWO'] = STR_TCK_OPTCOPYTOWO;
		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && ereg('f', $include))
			$options['boTickets.upload'] = STR_TCK_OPTUPLOADFILE;
		if (ereg('w', $include))
			$options['boWatches.add'] = STR_TCK_OPTWATCH;

		if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
			$options['htmlWiki.show'] = STR_CMMN_WIKI;

		asort($options);
		reset($options);
		while (list($value, $text) = each($options))
			$cmbText .= sprintf('<option value="%s">%s</option>', $value, $text);

		$cmbText .= '</select>';
		return $cmbText;
	}

	function PrintReassignForm($obj)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objProduct = CreateObject('dcl.dbProducts');
		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objHTMLPriorities = CreateObject('dcl.htmlPriorities');
		$objHTMLSeverities = CreateObject('dcl.htmlSeverities');

		$objProduct->Connect();
		$objProduct->Query('SELECT tcksetid FROM products WHERE id=' . $obj->product);
		$objProduct->next_record();
		$setid = $objProduct->f(0);

		$Template = CreateTemplate(array('hForm' => 'htmlTicketReassignForm.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', sprintf(STR_TCK_REASSIGNTICKET, $obj->ticketid));
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=boTickets.view&ticketid=' . $obj->ticketid));

		$Template->set_var('VAL_TICKETID', $obj->ticketid);
		$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($obj->responsible, 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
		$Template->set_var('CMB_PRIORITY', $objHTMLPriorities->GetCombo($obj->priority, 'priority', 'name', 0, false, $setid));
		$Template->set_var('CMB_TYPE', $objHTMLSeverities->GetCombo($obj->type, 'type', 'name', 0, false, $setid));

		$Template->pparse('out', 'hForm');
	}

	function ShowUploadFileForm($obj)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketAddAttachment.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_TCK_UPLOADATTACHMENT);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_TICKETID', $obj->ticketid);
		$Template->set_var('TXT_ATTACHFILE', STR_TCK_ATTACHFILE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=boTickets.view&ticketid=' . $obj->ticketid));

		$Template->pparse('out', 'hForm');
	}

	function ShowDeleteAttachmentYesNo($ticketid, $filename)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketDelAttachment.tpl'));

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_TCK_DELETEATTACHMENT);
		$Template->set_var('VAL_TICKETID', $ticketid);
		$Template->set_var('VAL_FILENAME', htmlspecialchars($filename));
		$Template->set_var('TXT_CONFIRMDELETE', sprintf(STR_TCK_CONFIRMDELATT, htmlspecialchars($filename)));
		$Template->set_var('BTN_YES', STR_CMMN_YES);
		$Template->set_var('BTN_NO', STR_CMMN_NO);

		$Template->pparse('out', 'hForm');
	}

	function DisplayGraphForm()
	{
		global $dcl_info;

		IncludeCalendar();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketGraph.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_TCK_ACTIVITYGRAPH);
		$Template->set_var('TXT_SHOWGRAPHFOR', STR_TCK_SHOWGRAPHFOR);

		$Template->set_var('CMB_DAYS', '<select name="days"><option value="7">7 ' . STR_TCK_DAYS . '</option><option value="14">14 ' . STR_TCK_DAYS . '</option></select>');
		$Template->set_var('TXT_ENDINGON', STR_TCK_ENDINGON);
		$Template->set_var('VAL_TODAY', date($dcl_info['DCL_DATE_FORMAT']));
		$Template->set_var('VAL_MENUACTION', 'boTickets.showgraph');
		$Template->set_var('BTN_OK', STR_CMMN_GO);

		$o = CreateObject('dcl.htmlProducts');
		$Template->set_var('CMB_PRODUCTS', $o->GetCombo(0, 'product', 'name', 0, 0, false));
		$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);

		$Template->pparse('out', 'hForm');
	}

	function my($rowlimit = 5)
	{
		$this->showmy('responsible', STR_TCK_MYTICKETS, STR_TCK_NOOPENTICKETS, $rowlimit);
		$this->showmy('createdby', STR_TCK_MYSUBMISSIONS, STR_TCK_NOSUBMISSIONS, $rowlimit);
	}

	function showSubmissions()
	{
		commonHeader();
		$this->showmy('createdby', STR_TCK_MYSUBMISSIONS, STR_TCK_NOSUBMISSIONS, 0);
	}

	function showmy($forField, $title, $noneMsg, $rowlimit)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();

		if ($rowlimit == 0)
		{
			$objView = CreateObject('dcl.boView');
			$objView->title = $title;
			$objView->style = 'report';
			$objView->table = 'tickets';
			$objView->AddDef('columns', '', array('ticketid', 'priorities.name', 'severities.name', 'responsible.short', 'summary'));
			$objView->AddDef('columnhdrs', '', array(
					STR_WO_JCN,
					STR_WO_SEQ,
					STR_WO_PRIORITY,
					STR_WO_SEVERITY,
					STR_WO_RESPONSIBLE,
					STR_WO_DEADLINE,
					STR_WO_SUMMARY));

			$objView->AddDef('filter', $forField, $GLOBALS['DCLID']);
			$objView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			if ($forField == 'createdby')
				$objView->AddDef('filternot', 'responsible', $GLOBALS['DCLID']);
			$objView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'ticketid'));

			$objHV = CreateViewObject($objView->table);
			$objHV->Render($objView);
			return;
		}

		$query = 'SELECT a.ticketid,a.summary FROM tickets a, priorities b, severities c, statuses d ';
		$query .= sprintf('WHERE a.%s=%d AND a.status=d.id AND d.dcl_status_type!=2 ', $forField, $GLOBALS['DCLID']);
		$query .= ' AND a.priority=b.id AND a.type=c.id';

		// Already showed the wo set we are responsible for...
		if ($forField == 'createdby')
			$query .= sprintf(' AND a.responsible!=%d', $GLOBALS['DCLID']);

		$query .= ' ORDER BY b.weight,c.weight,a.ticketid ';

		$obj->LimitQuery($query, 0, $rowlimit);

		$t = CreateTemplate(array('hForm' => 'htmlMy.tpl'));
		$t->set_block('hForm', 'row', 'hRow');
		$t->set_block('hForm', 'nothing', 'hNothing');
		$t->set_var('hRow', '');
		$t->set_var('hNothing', '');

		$t->set_var('TXT_TITLE', $title);
		$t->set_var('TXT_TOP', sprintf(STR_CMMN_TOPNUM, $rowlimit));

		if ($forField == 'responsible')
			$t->set_var('LNK_MY', menuLink('', 'menuAction=htmlTickets.show&filterReportto=' . $GLOBALS['DCLID']));
		else
			$t->set_var('LNK_MY', menuLink('', "menuAction=htmlTickets.showSubmissions"));

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				$t->set_var('COLOR_ROW', ($i++ % 2 == 0 ? '#cecece' : $dcl_info['DCL_COLOR_LIGHT']));
				$t->set_var('LNK_ROW', menuLink('', 'menuAction=boTickets.view&ticketid=' . $obj->f('ticketid')));
				$t->set_var('VAL_ROW', sprintf('(%d) %s', $obj->f('ticketid'), htmlspecialchars($obj->f('summary'))));
				$t->parse('hRow', 'row', true);
			}
			while ($obj->next_record());
		}
		else
		{
			$t->set_var('TXT_NOTHING', $noneMsg);
			$t->parse('hNothing', 'nothing');
		}

		$t->pparse('out', 'hForm');
	}

	function RenderOptions(&$aRecord)
	{
		$str = '<td>';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boTickets.view&ticketid=' . $aRecord['ticketid']) . '">' . STR_CMMN_VIEW . '</a>';
		//$str .= '&nbsp;|&nbsp;';
		$str .= '</td>';
		echo $str;
	}

	function RenderFilter(&$sPagerFormElements)
	{
		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : -1;
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : 0;
		$filterProduct = IsSet($GLOBALS['filterProduct']) ? $GLOBALS['filterProduct'] : 0;

		echo '<table style="border: 0px none;">';
		echo '<form method="post" action="' . menuLink('') . '">';
		echo '<tr><td style="width: 5%; white-space: nowrap;">';
		echo '<b>', STR_WO_STATUS, ':</b></td><td style="width: 5%; white-space: nowrap;">';

		$o = CreateObject('dcl.htmlSelect');
		$o->vDefault = $filterStatus;
		$o->sName = 'filterStatus';
		$o->iSize = 0;
		$o->sZeroOption = STR_CMMN_SELECTONE;

		$oStatus = CreateObject('dcl.dbStatuses');
		$oStatus->Connect();
		$oStatus->Query('SELECT id, name FROM statuses ORDER BY name');
		$o->aOptions = $oStatus->FetchAllRows();
		$i = count($o->aOptions);
		$o->aOptions[$i++] = array('-1', STR_CMMN_HIDECLOSEDTYPES);
		$o->aOptions[$i++] = array('-2', STR_CMMN_ONLYCLOSEDTYPES);
		echo $o->GetHTML();

		echo '</td><td></td><td><input type="submit" value="Filter">';
		echo '</td>';
		echo '<td rowspan="2" style="text-align: right; white-space: nowrap;">';
		echo $sPagerFormElements;
		echo '</td></tr>';
		echo '<tr><td style="width: 5%; white-space: nowrap;">';
		echo '<b>', STR_WO_RESPONSIBLE, ':</b></td><td style="width: 5%; white-space: nowrap;">';
		$oReport = CreateObject('dcl.htmlPersonnel');
		$oReport->createCombo($filterReportto, 'filterReportto', 'short', 0, false);

		echo '</td><td style="width: 5%; white-space: nowrap;"><b>', STR_WO_PRODUCT, ':</b></td><td style="width: 5%; white-space: nowrap;">';
		$oProduct = CreateObject('dcl.htmlProducts');
		$oProduct->createCombo($filterProduct, 'filterProduct', 'name', 0, false);

		echo '</td></tr>';
		echo '</form></table>';
	}

	function show()
	{
		global $dcl_info;

		commonHeader();

		$oView = CreateObject('dcl.boView');
		if ((IsSet($GLOBALS['btnNav']) || IsSet($GLOBALS['jumptopage'])) && IsSet($GLOBALS['startrow']) && IsSet($GLOBALS['numrows']))
		{
			if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '<<')
				$oView->startrow = $GLOBALS['startrow'] - $GLOBALS['numrows'];
			else if (IsSet($GLOBALS['btnNav']) && $GLOBALS['btnNav'] == '>>')
				$oView->startrow = $GLOBALS['startrow'] + $GLOBALS['numrows'];
			else
			{
				$iPage = $GLOBALS['jumptopage'];
				if ($iPage < 1)
					$iPage = 1;

				$oView->startrow = ($iPage - 1) * $GLOBALS['numrows'];
			}

			if ($oView->startrow < 0)
				$oView->startrow = 0;

			$oView->numrows = $GLOBALS['numrows'];
		}
		else
		{
			$oView->numrows = 15;
			$oView->startrow = 0;
		}

		$oView->table = 'tickets';
		$oView->style = 'report';
		$oView->title = STR_TCK_BROWSETCK;
		$oView->AddDef('columns', '', array('ticketid', 'products.name', 'statuses.name', 'priorities.name', 'severities.name', 'responsible.short', 'summary'));
		$oView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'ticketid'));

		$oView->AddDef('columnhdrs', '', array(
				STR_TCK_TICKET,
				STR_TCK_PRODUCT,
				STR_TCK_STATUS,
				STR_TCK_PRIORITY,
				STR_TCK_TYPE,
				STR_TCK_RESPONSIBLE,
				STR_TCK_SUMMARY));

		$filterStatus = '-1';
		$filterReportto = '0';
		$filterProduct = '0';
		$filterType = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];
		if (IsSet($GLOBALS['filterProduct']))
			$filterProduct = $GLOBALS['filterProduct'];
		if (IsSet($GLOBALS['filterType']))
			$filterType = $GLOBALS['filterType'];

		if ($filterStatus != '0')
		{
			if ($filterStatus == '-1')
				$oView->AddDef('filternot', 'statuses.dcl_status_type', '2');
			else if ($filterStatus == '-2')
				$oView->AddDef('filter', 'statuses.dcl_status_type', '2');
			else
				$oView->AddDef('filter', 'status', $filterStatus);
		}

		if ($filterReportto != '0')
			$oView->AddDef('filter', 'responsible', $filterReportto);

		if ($filterProduct != '0')
			$oView->AddDef('filter', 'product', $filterProduct);

		if ($filterType != '0')
			$oView->AddDef('filter', 'type', $filterType);

		$oHtml = CreateObject('dcl.htmlTicketBrowse');
		$oHtml->Render($oView);
	}
}
?>
