Update dcl_config Set dcl_config_varchar = '0.9.3' Where dcl_config_name = 'DCL_VERSION';
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime) values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', now());
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5);

Create Table dcl_wo_account (
	wo_id int4 not null,
	seq int4 not null,
	account_id int4 not null,
	primary key(wo_id, seq, account_id)
);

Insert Into dcl_wo_account Select jcn, seq, account From workorders where account is not null and account > 0;

Alter Table workorders Rename To workorders_tmp;

CREATE TABLE "workorders" (
		"jcn" "int4" NOT NULL,
		"seq" "int4" NOT NULL,
		"product" "int4" NOT NULL,
		"createby" "int4" NOT NULL,
		"createdon" "timestamp" NOT NULL,
		"closedby" "int4",
		"closedon" "date",
		"status" "int4" NOT NULL,
		"statuson" "timestamp" NOT NULL,
		"lastactionon" "timestamp",
		"deadlineon" "date",
		"eststarton" "date",
		"estendon" "date",
		"starton" "date",
		"esthours" "float8",
		"totalhours" "float8",
		"priority" "int4" NOT NULL,
		"severity" "int4" NOT NULL,
		"contact" varchar(50),
		"contactphone" char(10),
		"summary" varchar(100) NOT NULL,
		"notes" varchar(1024),
		"description" varchar(1024) NOT NULL,
		"responsible" "int4",
		"revision" varchar(20),
		"publicview" "bool",
		"etchours" "float8",
		"module_id" "int4",
		"wo_type_id" "int4"
	);

Insert Into workorders (jcn, seq, product, createby, createdon, closedby, closedon, status, statuson, lastactionon,
deadlineon, eststarton, estendon, starton, esthours,totalhours, priority, severity, contact, contactphone, summary, notes,
description, responsible, revision, etchours, module_id)
Select jcn, seq, product, createby, createdon, closedby, closedon, status, statuson, lastactionon,
deadlineon, eststarton, estendon, starton, esthours,totalhours, priority, severity, contact, contactphone, summary, notes,
description, responsible, revision, etchours, module_id From workorders_tmp;

Drop Table workorders_tmp;

Create Sequence seq_dcl_wo_type;

Create Table dcl_wo_type (
	wo_type_id int4 not null default nextval('seq_dcl_wo_type'),
	type_name varchar(50) not null,
	active char(1) not null,
	Primary Key(wo_type_id)
);

Insert Into dcl_wo_type (type_name, active) values ('Issue', 'Y');
Update workorders set wo_type_id = 1;

Create Table dcl_session (
	dcl_session_id varchar(32) not null primary key,
	personnel_id int4 not null,
	create_date timestamp not null,
	update_date timestamp not null,
	session_data text null
);

Create Table dcl_preferences (
	personnel_id int4 not null primary key,
	preferences_data text null
);

create unique index "uc_accounts_short" on accounts("short");
create unique index "uc_accounts_name" on accounts("name");

Create Table dcl_wiki (
	dcl_entity_type_id int4 not null,
	dcl_entity_id int4 not null,
	dcl_entity_id2 int4 not null,
	page_name varchar(255) not null,
	page_text text null,
	page_date timestamp null,
	page_ip varchar(255) null,
	primary key (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name)
);
