/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * display.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: display.h,v 1.3 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __DISPLAY_H__
#define __DISPLAY_H__

typedef enum
{
   ERR_MSG=0,
   DEBUG_MSG=1,
   INFO_MSG=2,
   USER_MSG=3,       /* it is an user nickname to put in the user list */
   OP_MSG=4,         /* it is an operator nickname to put in the operator list */
   USER_IN_MSG=5,    /* an user enters the hub */
   USER_OUT_MSG=6,   /* an user leaved the hub */
   GLOB_CHAT_MSG=7,  /* message in the global chat */
   USER_INFO_MSG=8,  /* info about a user */
   HUBNAME_MSG=9,    /* hubname */
   SRESULT_MSG=10,   /* search result */

   /* (sub) is for data coming from com port */
   SUB_USER_MSG=11,  /* (sub) nick */

   /* (xfer) */
   XFER_UL_START=12,    /* beginning of upload */
   XFER_UL_END=13,      /* successful end of upload */
   XFER_UL_FATAL=14,    /* fatal end of upload */
   XFER_DL_START=15,    /* beginning of download */
   XFER_DL_END=16,      /* successful end of download */
   XFER_DL_FATAL=17,    /* fatal end of download */

   HUB_DISCONNECT=18,   /* the hub has closed the connection */

   PRIV_MSG=19,         /* private message from a user */

   XFER_LST_R=20,       /* display transfer list (running transfer) */
   XFER_LST_Q=21,       /* display transfer list (queued transfer) */

	HUB_REDIRECT=22,		/* the hub wants to redirect you to another hub */

	XFER_DL_UNQUEUED=23,	/* a queued download has been aborted (too old) */

	CMD_KB=24,				/* it a queued keyboard command to start */

   HUB_RECONNECT=25,    /* the hub is available */

	XFER_LS_START=26,		/* beginning of file list download */
	XFER_LS_END=27,		/* successful end of file list download */
	XFER_LS_FATAL=28,		/* fatal end of file list download */

	LS_ENTRY=29,			/* it is a file entry of a user shared file list */
	LS_END=30,				/* end of user shared file list */

   XFER_UL_RUN=31,      /* real beginning of upload */
   XFER_DL_RUN=32,      /* real beginning of download */
   XFER_LS_RUN=33,      /* real beginning of LS */

	XFER_LS_UNQUEUED=34,	/* a queued LS has been aborted (too old) */

	ASTART_MSG=35,
	ASTOP_MSG=36,
	REFRESH_MSG=37,
   XFER_LST_BEGIN=38,       /* display transfer list (running transfer) */
	VAR_MSG=39,
   XFER_LST_END=40,       /* display transfer list (running transfer) */

	GETPASS_MSG=41,		/* the hub wants the client to send a passwd */
	ADMIN_MSG=42,			/* the user is logged as an admin */

   XFER_UL_STAT=43,    /* display the statistic of an upload */
	PROGRESS_BAR=44,		/* used to report the progress of tasks */

	GDL_QLST_BEGIN=45,
	GDL_QLST_ENTRY=46,
	GDL_QLST_END=47,

	GDL_LST_BEGIN=48,
	GDL_LST_ENTRY=49,
	GDL_LST_END=50,

	UADDR_LST_BEGIN=51,
	UADDR_LST_ENTRY=52,
	UADDR_LST_END=53,
	UADDR_LST_ADD=54,
	UADDR_LST_REMOVE=55,

	DISPLAY_RELAY=56,			/* take the first parameter and display it as an output message */

	LS_BEGIN=57,				/* beginning of user shared file list */
	LOCATE_USER=58,
	LS_CACHE_MSG=59,				/* name of a user having its share list received */

	ULIST_FILE=60,				/* end of /ULISTFILE command */
} DISP_MSG_TYPE;

/*******************************/
/* display a formatted message */
/**************************************************************************/
/* this function is thread safe, multiple disp_msg won't mix their output */
/* The displayed message will have this form:                             */
/* MSGTP] "fnc_name"xxxxx|yyyyy|                                          */
/* fnc_name can be NULL. one or more string can be provided. They will be */
/* append after the fnc_name and will be separated by |                   */
/**************************************************************************/
/* if produced_string is not NULL, the printed string is not freed but */
/* put inside.                                                         */
/***********************************************************************/
void disp_msg_full(DISP_MSG_TYPE msg_type,GString **produced_string,const char *fnc_name, ...);

/****************************************************************************************/
/* same as the previous function except the string is not printed but written into file */
/****************************************************************************************/
void disp_msg_full_infile(int file_fd,DISP_MSG_TYPE msg_type,GString **produced_string,const char *fnc_name, ...);

/***************************************************************************************/
/* it is a simplified version of the previous ones which does not keep produced string */
/***************************************************************************************/
#define disp_msg(msg_type,fnc_name...)			disp_msg_full(msg_type,NULL,fnc_name)

#define disp_msg_infile(file_fd,msg_type,fnc_name...)			disp_msg_full_infile(file_fd,msg_type,NULL,fnc_name)

/***************************************************/
/* display a formatted message built from an array */
/***************************************************/
/* The displayed message will have this form:      */
/* MSGTP] "fnc_name"fix_part|yyyyy|                */
/* fnc_name can be NULL. yyyyy is the list of all  */
/* strings of string_array separated by '$'        */
/***************************************************/
void disp_msg_ptr_array(DISP_MSG_TYPE msg_type,const char *fnc_name,const char *fix_part,GPtrArray *string_array);

/***********************************/
/* change the current log filename */
/************************************************/
/* if filename==NULL, log into file is disabled */
/************************************************/
void change_logfile(char *filename);

/***************************************/
/* change the current ERR log filename */
/************************************************/
/* if filename==NULL, log into file is disabled */
/************************************************/
void change_errlogfile(char *filename);


#endif
