/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dfactory.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dfactory.c,v 1.1 2003/05/31 13:50:14 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "factory.h"
#include "dfactory.h"
#include "packet_define.h"

/***********************************************/
/* set of functions to unbuild typical packets */
/***********************************************/

/********************************************************************/
/* take the given packet (CS_ID_CHANGE) and extract the information */
/*************************************************************************/
/* Note: packet must be valid (0xE3,matching size and type CS_ID_CHANGE) */
/*************************************************************************/
/* packet size = 1+4+1+4 */
/*************************/
guint32 df_id_change(GByteArray *packet)
{
	guint8 *p;

	p=packet->data+6;	/* skip 0xE3, packet size and packet type */
	return take_lsb_4bytes(p);
}

/************************************************************************/
/* take the given packet (CS_FOUND_SOURCES) and extract the information */
/*****************************************************************************/
/* Note: packet must be valid (0xE3,matching size and type CS_FOUND_SOURCES) */
/*****************************************************************************/
/* output: file_hash is filled with the 16bytes hash code               */
/*         ip_set is initialized and filled with DEF_IP_PORT structures */
/************************************************************************/
/* min packet size = 1+4+1+16+1 */
/********************************/
void df_found_sources(GByteArray *packet, guint8 *file_hash, GArray **ip_set)
{
	guint8 *p;
	guint8 nb_ip;
	int i;

	p=packet->data+6;	/* skip 0xE3, packet size and packet type */
	
	memcpy(file_hash,p,16);
	p+=16;
	nb_ip=*p++;

	*ip_set=g_array_new(FALSE,FALSE,sizeof(DEF_IP_PORT));

	for(i=0;i<nb_ip;i++)
	{
		DEF_IP_PORT dip;

		if(((p+6)-packet->data)>packet->len)		/* out of array ? */
		{
			fprintf(stderr,"warning: df_found_sources: undersized packet.\n");
			break;
		}

		dip.ip=take_lsb_4bytes(p);
		dip.port=take_lsb_2bytes(p+4);
		p+=6;

		g_array_append_val(*ip_set,dip);
	}
	return;
}

