/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * toolkit.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: toolkit.c,v 1.1 2003/05/31 13:50:57 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include "toolkit.h"

/******************************************************************/
/* copy the source string into the dest string (upto max_byte-1). */
/* The dest string is always \0 terminated                        */
/******************************************************************/
void strncpy_max(char *destination, const char *source, unsigned int max_byte)
{
	strncpy(destination,source,max_byte-1);
	destination[max_byte-1]='\0';
}

/***************************************************/
/* compute the size of a NULL terminated ptr array */
/***************************************************/
int size_of_null_array(void **array)
{
	int nb=0;

	while(*array!=NULL)
	{
		nb++;
		array++;
	}
	return nb;
}

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ----------------------- memory access macro ------------------------------ */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*****************************************************************************/
/* some CPU accepts to read word not aligned on a word boundary, other don't */
/*****************************************************************************/
#ifdef NO_UNALIGNED_ACCESS
/* bad luck, the CPU is very stupid */
guint16 get_unaligned_guint16(guint8 *addr)
{
	guint16 a,b;

	/* the &0xFF is not required because we work with unsigned values */
	a=((guint16)addr[0]);
	b=((guint16)addr[1]);
#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<8)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<8)|a;
#else
#error unsupported byte order
#endif
}

guint32 get_unaligned_guint32(guint8 *addr)
{
	guint32 a,b;

	/* the &0xFFFF is not required because we work with unsigned values */
	a=get_unaligned_guint16(addr);
	b=get_unaligned_guint16(addr+2);

#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<16)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<16)|a;
#else
#error unsupported byte order
#endif
}

guint64 get_unaligned_guint64(guint8 *addr)
{
	guint64 a,b;

	/* the &0xFFFF is not required because we work with unsigned values */
	a=get_unaligned_guint32(addr);
	b=get_unaligned_guint32(addr+4);

#if G_BYTE_ORDER == G_BIG_ENDIAN
	return (a<<32)|b;
#elif G_BYTE_ORDER == G_LITTLE_ENDIAN
	return (b<<32)|a;
#else
#error unsupported byte order
#endif
}

#endif




