/*
 * A Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtCore/QStringList>
#include <QtCore/QDebug>
#include <QtCore/QCoreApplication>
#include <QtDBus/QDBusConnection>

#include <Decibel/AccountManager>
#include <Decibel/DBusNames>

// Simplistic demo to list all accounts known to the account manager.
// Usage: $0

int main(int argc, char ** argv)
{
    QCoreApplication app(argc, argv);

    // Connect to session bus:
    if (!QDBusConnection::sessionBus().isConnected())
    {
        qDebug("Cannot connect to the D-BUS session bus.\n"
               "To start it, run:\n"
               "\teval `dbus-launch --auto-syntax`\n");
        return 1;
    }

    // Register custom types:
    Decibel::registerTypes();

    // connect to the Decibel daemon:
    de::basyskom::Decibel::AccountManager
    account_mgr(Decibel::daemon_service, Decibel::daemon_accountmanager_path,
                QDBusConnection::sessionBus(), &app);

    QDBusReply<QList<uint> > accountlist = account_mgr.listAccounts();
    if(!accountlist.isValid())
    {
            QDBusError error = accountlist.error();
            qDebug() << "DBus Error while getting account list:"
                     << error.type() << ":"
                     << error.message();
            return 3;
    }

    int i;
    foreach (i, accountlist.value())
    {
        QDBusReply<QVariantMap> accountdetails = account_mgr.queryAccount(i);
        if(!accountlist.isValid())
        {
            QDBusError error = accountlist.error();
            qDebug() << "DBus Error while querying account details:"
                     << error.type() << ":"
                     << error.message();
            return 4;
        }

        qDebug() << "Accounthandle" << i << ":";
        QStringList keylist = accountdetails.value().keys();
        QString j;
        foreach (j, keylist)
        {
            qDebug() << "    " << j << accountdetails.value().value(j);
        }
    }

    return 0;
}
