/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/configuration.hpp
 *
 * $Id: configuration.hpp,v 1.10 2005/06/23 09:54:18 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] Use-Case: The include-files for configuring
 * the diagnostics framework. 
 *
 * Include this file only, if you have to configure the diagnostics
 * framework (usually the case in the main-component of an
 * executable). If you only use the diagnostics framework, include
 * @ref diagnostics/macros/front_end.hpp (probably, you are not doing
 * this directly, see the documentation of this file). If you are
 * testing, include diagnostics/unittest.hpp.
 */
#ifndef DIAGNOSTICS__CONFIGURATION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__CONFIGURATION_HPP__INCLUDE_GUARD

#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/frame/set_initial_loggers.hpp>

#endif

// vim:ts=4:sw=4
