/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/lib_annotations.t.cpp
 *
 * @brief [LEVEL: pre-alpha] testing lib_annotations.hpp
 *
 * $Id: lib_front_end.t.cpp,v 1.6 2005/06/23 09:54:22 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @todo add testcases
 */

#include <diagnostics/unittest.hpp>

// We use the global build level for the annotations.  Usually it is
// the other way around, i.e., DEBUG__LEVEL__ is defined as
// XXX_DEBUG__LEVEL__. 
#define XXX_DEBUG__LEVEL__ DEBUG__LEVEL__

// component
#include <diagnostics/lib_annotations.hpp>

// backdoor
#include <diagnostics/unittest/test_system/current_test_logger.hpp>

// used component
#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/util/to_string.hpp>

// test support
#include <diagnostics/util/dummy_logger.ts.hpp>
#include <diagnostics/util/assert_record.ts.hpp>

#define TEST_COMPONENT_NAME lib_annotations
#define TEST_COMPONENT_NAMESPACE diagnostics


DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;
using ::diagnostics::unittest::internal::Current_Test_Logger;

void test_exec(Test_Data & data)
{
	bool was_here(false);
	
	XXX_DEBUG_EXEC(was_here=true);
	TEST_ASSERT_RELATION(XXX_DEBUG__LEVEL__>=LEVEL_DEBUG,==,was_here);
	

	was_here=false;
	XXX_DEBUG_EXEC_ENTER;
	was_here=true;
	XXX_DEBUG_EXEC_EXIT;
	TEST_ASSERT_RELATION(XXX_DEBUG__LEVEL__>=LEVEL_DEBUG,==,was_here);

	was_here=false;
	XXX_AUDIT_EXEC(was_here=true);
	TEST_ASSERT_RELATION(XXX_DEBUG__LEVEL__>=LEVEL_AUDIT,==,was_here);
	

	was_here=false;
	XXX_AUDIT_EXEC_ENTER;
	was_here=true;
	XXX_AUDIT_EXEC_EXIT;
	TEST_ASSERT_RELATION(XXX_DEBUG__LEVEL__>=LEVEL_AUDIT,==,was_here);
}



TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&test_exec,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
