/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/logger/stream_logger.cpp
 *
 * @brief [LEVEL: beta] Implementation of the @ref diagnostics::Stream_Logger class
 *
 * $Id: stream_logger.cpp,v 1.10 2005/06/23 09:54:21 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/logger/stream_logger.hpp>

// for DIAGNOSTICS_PANIC_LOG
#include <diagnostics/frame/logging_facility.hpp>

#include <diagnostics/frame/record.hpp>

#include <diagnostics/frame/logging_config_exception.hpp>

#include <diagnostics/util/to_string.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

Stream_Logger::~Stream_Logger()
{
}

Stream_Logger::Stream_Logger(::std::ostream & stream) 
    : m_stream(stream)
{
}

void Stream_Logger::log(Record const & record)
{
    using ::diagnostics::internal::to_string;
    m_stream << record << ::std::endl;
    if(!m_stream.good()) 
	DIAGNOSTICS_PANIC_LOG("Stream Logger is unable to write record: " + to_string(record));
}

void Stream_Logger::close()
{
}


DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
