/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/filter_test_data.t.cpp
 *
 * @brief [LEVEL: beta] testing @ref diagnostics::unittest::Filter_Test_Data
 *
 * $Id: filter_test_data.t.cpp,v 1.10 2005/06/23 09:54:25 esdentem Exp $
 *
 * @author Christian Schallhart
 */
#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_system/filter_test_data.hpp>
#include <diagnostics/unittest/test_system_exception.hpp>

// test support
#include <diagnostics/util/dummy_test_data.ts.hpp>

#define TEST_COMPONENT_NAME Filter_Test_Data
#define TEST_COMPONENT_NAMESPACE diagnostics::unittest

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;

void attaching(Test_Data & test_data)
{
    Dummy_Test_Data data;
    Filter_Test_Data filter;

    TEST_ASSERT(filter.backend()==NULL);
    TEST_ASSERT(filter.prefix()=="");

    TEST_THROWING_BLOCK_ENTER;
    filter.get("");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    TEST_THROWING_BLOCK_ENTER;
    filter.compare("1","2");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    
    filter.attach("",&data);

    TEST_ASSERT(filter.backend()==&data);
    TEST_ASSERT(filter.prefix()=="");

    filter.attach("1",&data);

    TEST_ASSERT(filter.backend()==&data);
    TEST_ASSERT(filter.prefix()=="1");
    

    TEST_THROWING_BLOCK_ENTER;
    filter.attach("",NULL);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
    TEST_ASSERT(filter.backend()==&data);
    TEST_ASSERT(filter.prefix()=="1");
}


void zero_filtering(Test_Data & test_data)
{
    Dummy_Test_Data data;
    Filter_Test_Data filter;

    filter.attach("",&data);

    typedef Dummy_Test_Data::Data_t::const_iterator Iter_t;
    Iter_t cur(data.data().begin());
    Iter_t const end(data.data().end());
    for(;cur!=end;++cur){
	TEST_ASSERT(data.get(cur->first)==cur->second);
	TEST_ASSERT(data.get(cur->first)==filter.get(cur->first));
    }

    TEST_THROWING_BLOCK_ENTER;
    data.get("NOT CONTAINED");
    TEST_THROWING_BLOCK_EXIT(Test_Exception);

    TEST_THROWING_BLOCK_ENTER;
    filter.get("NOT CONTAINED");
    TEST_THROWING_BLOCK_EXIT(Test_Exception);

    TEST_THROWING_BLOCK_ENTER;
    data.compare("NOT CONTAINED","x");
    TEST_THROWING_BLOCK_EXIT(Test_Exception);

    TEST_THROWING_BLOCK_ENTER;
    filter.compare("NOT CONTAINED","x");
    TEST_THROWING_BLOCK_EXIT(Test_Exception);
}

void filtering1(::std::string const & prefix, Test_Data & test_data)
{
    typedef Dummy_Test_Data::Data_t::const_iterator Iter_t;
    
    Dummy_Test_Data data;
    Filter_Test_Data filter;

    filter.attach(prefix,&data);
    
    ::std::string result;
    Iter_t cur(data.data().begin());
    Iter_t const end(data.data().end());
    for(;cur!=end;++cur){
	if(prefix.size()!=0) {
	    if(cur->first.find(prefix)==0) {
		::std::string suffix(cur->first);
		suffix.erase(0,prefix.size());
		TEST_ASSERT(data.get(cur->first)==filter.get(suffix));
		result+= filter.get(suffix) + "\n";
	    }
	}
	else {
	    ::std::string suffix(cur->first);
	    TEST_ASSERT(data.get(cur->first)==filter.get(suffix));
	    result+= filter.get(suffix) + "\n";
	}
	
    }
    // if Dummy_Test_Data changed somehow
    TEST_ASSERT(test_data.compare("Filter: '"+prefix+"'",result));
}


void filtering(Test_Data & test_data)
{
    filtering1(::std::string(),test_data);
    filtering1("1",test_data);
    filtering1("10",test_data);
    filtering1("X",test_data);
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&attaching,LEVEL_PROD);
TEST_NORMAL_CASE(&zero_filtering,LEVEL_PROD);
TEST_NORMAL_CASE(&filtering,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;
// vim:ts=4:sw=4
