/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_suite_traversal.cpp
 *
 * @brief [LEVEL: beta] Implementation of @ref
 * diagnostics::unittest::Test_Suite_Traversal middle-class
 *
 * $Id: test_suite_traversal.cpp,v 1.9 2005/06/23 09:54:27 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_system/test_suite_traversal.hpp>

#include <diagnostics/unittest/test_suite.hpp>
#include <diagnostics/unittest/test_case.hpp>
#include <diagnostics/unittest/test_system_exception.hpp>
#include <diagnostics/unittest/name_separators.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Test_Suite_Traversal::Test_Suite_Traversal()
{
}

Test_Suite_Traversal::~Test_Suite_Traversal()
{
}

void Test_Suite_Traversal::traverse(Test_Suite const & test_suite,
									::std::string const & mask,
									Level_t const level)
{
    if(!mask_adheres_convention(mask))
	throw Test_System_Exception("Invalid mask '" + mask + "'");

    //// must begin with a '/' (DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)
    //if(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)!=0) 
    //	throw Test_System_Exception("The mask must start with a '" 
    //				    DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR "'");
    //// is not allowed to conatain '//' (DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    //if(mask.find(DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)!= ::std::string::npos)
    //	throw Test_System_Exception("The mask is not allowed to contain a '" 
    //				    DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR "'");
    //
    //// is not allowed to contain a CASE_SEPERATOR directly followed by another one.
    //// at the moment, that's the same as the previous check -- but who knows.... the future.
    //if(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR !=
    //   DIAGNOSTICS_UNITTEST_TEST_DATA_NAME_SEPARATOR)
    //	if(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
    //		     DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR)!= ::std::string::npos)
    //	    throw Test_System_Exception("The mask is not allowed to contain a '" 
    //					DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
    //					"' direclty followed by another one");
    Path_t path;
    enter_hook(test_suite,mask,level);
    try {
		p_traverse(test_suite,mask,path,level);
    } catch(...) {
		exit_hook(test_suite,mask,level,true);
		throw;
    }
    exit_hook(test_suite,mask,level,false);
}


void Test_Suite_Traversal::p_traverse(Test_Suite const & test_suite,
									  ::std::string mask,
									  Path_t & path,
									  Level_t const level)
{
    if(test_suite.name().size()!=0) {
		// test_suite has a name
		if(mask.find(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
					 DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK)==0) {
			// there is an asterisk for this level
			if(mask.size()!=sizeof(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
								   DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK)-1) {
				// asterisk is only for this level -- mask has to change
				mask.erase(0,sizeof(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
									DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK)-1);
			}
		}
		else {
			// there is not asterisk for this level
			::std::string const prefix(DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR+test_suite.name());
			if(mask.find(prefix)==0) {
				// the name of the suite is matched
				mask.erase(0,prefix.size());
			}
			else return;
		}
    }
    

    visit_hook(test_suite,path,level);
    path.push_back(test_suite.name());
    {
		Test_Suite::Test_Cases_t::const_iterator current(test_suite.test_cases().begin());
		Test_Suite::Test_Cases_t::const_iterator const end(test_suite.test_cases().end());
		for(;current!=end;++current) p_traverse(**current,mask,path,level);
    }
	
    {
		Test_Suite::Test_Suites_t::const_iterator current(test_suite.test_suites().begin());
		Test_Suite::Test_Suites_t::const_iterator const end(test_suite.test_suites().end());
		for(;current!=end;++current) p_traverse(**current,mask,path,level);
    }
    path.pop_back();
    leave_hook(test_suite,path,level);
}


void Test_Suite_Traversal::p_traverse(Test_Case const & test_case,
									  ::std::string const & mask,
									  Path_t const & path,
									  Level_t const level)
{
    // order is essential in this test. is_testable_at(LEVEL_TEST) throws!
    if(level!=LEVEL_TEST && !test_case.is_testable_at(level)) return;
	
    // asterisk or name matches
    if(mask==DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR 
	   DIAGNOSTICS_UNITTEST_TEST_CASE_ASTERISK || 
       mask==DIAGNOSTICS_UNITTEST_TEST_CASE_NAME_SEPARATOR+test_case.name())
		visit_hook(test_case,path,level);
}



void Test_Suite_Traversal::enter_hook(Test_Suite const & test_suite,
				      ::std::string const & mask,
				      Level_t const level)
{
}

void Test_Suite_Traversal::exit_hook(Test_Suite const & test_suite,
				     ::std::string const & mask,
				     Level_t const level,
				     bool const exception_going_through)
{
}

void Test_Suite_Traversal::visit_hook(Test_Suite const & test_suite,
				      Path_t const & path,
				      Level_t const level)
{
}

void Test_Suite_Traversal::leave_hook(Test_Suite const & test_suite,
				      Path_t const & path,
				      Level_t const level)
{
}

void Test_Suite_Traversal::visit_hook(Test_Case const & test_case,
				      Path_t const & path,
				      Level_t const level)
{
}



UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
