/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include "appsupport.h"
#include "icon_entry.h"

void
icon_entry_destroy (icon_entry * entry)
{
  g_assert (entry);
  g_free (entry->name);
  g_free (entry->dn);
  g_free (entry);
}

icon_entry *
icon_entry_new (icon_entry * entry)
{
  icon_entry *new = g_new (icon_entry, 1);
  new->name = NULL;
  new->dn = NULL;
  new->type = DIRADMIN_UNDEFINED;
  if (entry != NULL)
    {
      new->name = g_strdup (entry->name);
      new->dn = g_strdup (entry->dn);
      new->type = entry->type;
    }
  return new;
}

icon_entry *
icon_entry_new_with_parms (gchar * name, gchar * dn, icon_entry_type type)
{
  icon_entry *new = g_new (icon_entry, 1);
  new->name = g_strdup (name);
  new->dn = g_strdup (dn);
  new->type = type;
  return new;
}


guint32 icon_list_last_click_time = 0;
int icon_list_last_clicked_icon = -1;

gboolean
icon_list_click_event (GnomeIconList * widget,
		       GdkEventButton * event, gpointer user_data)
{

  guint32 icon_list_click_time = event->time;
  int icon_list_clicked_icon =
    gnome_icon_list_get_icon_at (widget, event->x, event->y);

  if (event->button == 1 && icon_list_clicked_icon >= 0)
    {

//    g_print( "\npressed left mouse button on icon %d, delta time %d\n",
//       icon_list_clicked_icon,
//       icon_list_click_time - icon_list_last_click_time
//   );

      if (icon_list_last_clicked_icon == icon_list_clicked_icon
	  && icon_list_last_click_time == icon_list_click_time)
	{
	  //g_print ("double click on same icon!");
	  gtk_signal_emit_by_name (GTK_OBJECT
				   (lookup_widget
				    (GTK_WIDGET (widget),
				     "button_modifyselection")), "clicked");
	}
      icon_list_last_click_time = icon_list_click_time;
      icon_list_last_clicked_icon = icon_list_clicked_icon;
    }

  return FALSE;
}
