
#include <AppKit/AppKit.h>
#include "AppController.h"

#define XCONF "/etc/X11/XF86Config-4"

@implementation AppController

- (void) awakeFromNib
{
    int re,i;
    FILE *u,*f;
    char buffer[200];
    float r,g,b;

    u=popen("xgamma 2>&1","r");
    re=fread(buffer,1,199,u);
    buffer[re]='\0';
    for (i=0; i<strlen(buffer); i++) {
	if (!isdigit(buffer[i])) {
	    if (buffer[i]!='.') {
		buffer[i]=' ';
	    }
	}
    }
    pclose(u);

    /* printf("%s\n",buffer); */
    sscanf(buffer,"%f %f %f",&r,&g,&b);
    /* printf("%f %f %f\n",r,g,b); */

    if (f=fopen(XCONF,"rw")) {
	fclose(f);
	[button setEnabled:YES];
    }

    [gamma setFloatValue:((r+g+b)/3.0)];
    [rgamma setFloatValue:r];
    [ggamma setFloatValue:g];
    [bgamma setFloatValue:b];
    [window center];
}

- (void) run: (id)sender
{
    char command[200];
    float g=[gamma floatValue];
    [rgamma setFloatValue:g];
    [ggamma setFloatValue:g];
    [bgamma setFloatValue:g];

    sprintf(command,"xgamma -gamma %0.3f",g);
    NSLog(@"%s",command);    
    NSLog(@"Setting gamma to %0.3f",g);
    system(command);
}

- (void) runr: (id)sender
{
    char command[200];
    float gr=[rgamma floatValue];

    sprintf(command,"xgamma -rgamma %0.3f",gr);
    NSLog(@"%s",command);    
    NSLog(@"Setting rgamma to %0.3f",gr);    
    system(command);
}

- (void) rung: (id)sender
{
    char command[200];
    float gg=[ggamma floatValue];

    sprintf(command,"xgamma -ggamma %0.3f",gg);
    NSLog(@"%s",command);    
    NSLog(@"Setting ggamma to %0.3f",gg); 
    system(command);
}

- (void) runb: (id)sender
{
    char command[200];
    float gb=[bgamma floatValue];

    sprintf(command,"xgamma -bgamma %0.3f",gb);
    NSLog(@"%s",command);    
    NSLog(@"Setting bgamma to %0.3f",gb);
    system(command);
}

- (void) save: (id)sender
{
    /*
    Write Gamma r g b to the Section "Monitor" below
    DefaultDepth in /etc/X11/XF86Config-4
    */

    FILE *f,*f2;
    char buffer[300];
    int ok=0;

    f=fopen(XCONF,"rw");
    f2=fopen("/etc/X11/XF86Config-4.DisplayCalibrator","w");

    if (f==NULL) {
	printf("There was some problem with " XCONF "\n");
    } else {
	while(fgets(buffer,299,f)) {
	    if ((strstr(buffer,"Gamma")!=NULL) && (ok==0)) {
		/*ok=1;*/
	    } else {
		fprintf(f2,"%s",buffer);
	    }
	    if (strstr(buffer,"VertRefresh")!=NULL) {
		if (ok!=1) {
		    fgets(buffer,299,f);
		    if (strstr(buffer,"Gamma")!=NULL) {
			fprintf(f2,"\tGamma\t\t%0.3f %0.3f %0.3f\n",[rgamma floatValue],[ggamma floatValue],[bgamma floatValue]);
			ok=1;
		    } else {
			fprintf(f2,"\tGamma\t\t%0.3f %0.3f %0.3f\n",[rgamma floatValue],[ggamma floatValue],[bgamma floatValue]);
			ok=1;
			fprintf(f2,"%s",buffer);
		    }
		}
		if (ok==2) {
		    fprintf(f2,"\tGamma\t\t%0.3f %0.3f %0.3f\n",[rgamma floatValue],[ggamma floatValue],[bgamma floatValue]);
		    ok=1;
		}
	    }

	}
	fclose(f);
	if (f2!=NULL) fclose(f2);
	
	rename(XCONF,"/etc/X11/XF86Config-4.Backup");
	rename("/etc/X11/XF86Config-4.DisplayCalibrator",XCONF);
    }
}

@end
