#ifndef _LADSPAEFFECT_H_INCLUDED
#define _LADSPAEFFECT_H_INCLUDED

#include "config.h"

#ifdef HAVE_LADSPA
#include "effect.h"
#include <ladspa.h>

class LadspaEffect;

class LadspaEffectChannel : public EffectChannel
{
public:
	LadspaEffectChannel(LadspaEffect *e, unsigned long in_port, unsigned long out_port);
	LadspaEffectChannel(LadspaEffectChannel *c, LadspaEffect *e, unsigned long in_port, unsigned long out_port);
	~LadspaEffectChannel();

	void setControl(unsigned long port, float data);
	void setBuffer(float *buffer);
	void setGain(float gain);
	LadspaEffect *effect();
protected:
	void process(unsigned long nsamples);
	LADSPA_Handle e_handle;
	float *e_port_data;
	int e_in_port;
	int e_out_port;
	float e_gain;
	float *e_data;

	friend class LadspaEffect;
};

class LadspaEffect : public Effect
{
public:
	LadspaEffect();
	~LadspaEffect();
	
	bool loadEffect(unsigned long samplerate, unsigned long id, const char *name);
	unsigned long ports();
	bool isControl(unsigned long port);
	bool isInput(unsigned long port);
	float portMin(unsigned long port);
	float portMax(unsigned long port);
	float portDefault(unsigned long port);
	const char *portName(unsigned long port);

	LadspaEffectChannel *left();
	LadspaEffectChannel *right();
	void setControl(unsigned long port, float data);
	float control(unsigned long port);
	void setGain(float gain);
protected:
	void setupPorts();
	void *dl_handle;
	const LADSPA_Descriptor *e_desc;

	friend class LadspaEffectChannel;
};

#endif /* HAVE_LADSPA */
#endif
