import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import getQueryParams

class LaurasComics(BasicComicModule):
    latestUrl = 'http://www.laurascomics.com/'
    imageUrl = 'http://www.laurascomics.com/index.php?comicid=%s'
    imageSearch = re.compile(r'<img src=(/showcomic.php\?comicid=\d+)>', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(index.php\?comicid=\d+)"><img src="/images/gprev.gif"', re.IGNORECASE)
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        return getQueryParams(imageUrl)['comicid'][0]
